/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.model.Units;
import org.opentripplanner.routing.api.request.preference.TimeSlopeSafetyTriangle;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;
import org.opentripplanner.routing.core.VehicleRoutingOptimizeType;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.lang.ObjectUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class ScooterPreferences
implements Serializable {
    public static final ScooterPreferences DEFAULT = new ScooterPreferences();
    private final double speed;
    private final double reluctance;
    private final VehicleRentalPreferences rental;
    private final VehicleRoutingOptimizeType optimizeType;
    private final TimeSlopeSafetyTriangle optimizeTriangle;

    private ScooterPreferences() {
        this.speed = 5.0;
        this.reluctance = 2.0;
        this.rental = VehicleRentalPreferences.DEFAULT;
        this.optimizeType = VehicleRoutingOptimizeType.SAFE_STREETS;
        this.optimizeTriangle = TimeSlopeSafetyTriangle.DEFAULT;
    }

    private ScooterPreferences(Builder builder) {
        this.speed = Units.speed(builder.speed);
        this.reluctance = Units.reluctance(builder.reluctance);
        this.rental = builder.rental;
        this.optimizeType = Objects.requireNonNull(builder.optimizeType);
        this.optimizeTriangle = Objects.requireNonNull(builder.optimizeTriangle);
    }

    public static Builder of() {
        return new Builder(DEFAULT);
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public double speed() {
        return this.speed;
    }

    public double reluctance() {
        return this.reluctance;
    }

    public VehicleRentalPreferences rental() {
        return this.rental;
    }

    public VehicleRoutingOptimizeType optimizeType() {
        return this.optimizeType;
    }

    public TimeSlopeSafetyTriangle optimizeTriangle() {
        return this.optimizeTriangle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScooterPreferences that = (ScooterPreferences)o;
        return DoubleUtils.doubleEquals((double)that.speed, (double)this.speed) && DoubleUtils.doubleEquals((double)that.reluctance, (double)this.reluctance) && Objects.equals(this.rental, that.rental) && this.optimizeType == that.optimizeType && this.optimizeTriangle.equals(that.optimizeTriangle);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.speed, this.reluctance, this.rental, this.optimizeType, this.optimizeTriangle});
    }

    public String toString() {
        return ToStringBuilder.of(ScooterPreferences.class).addNum("speed", (Number)this.speed, (Number)ScooterPreferences.DEFAULT.speed).addNum("reluctance", (Number)this.reluctance, (Number)ScooterPreferences.DEFAULT.reluctance).addObj("rental", (Object)this.rental, (Object)ScooterPreferences.DEFAULT.rental).addEnum("optimizeType", (Enum)this.optimizeType, (Enum)ScooterPreferences.DEFAULT.optimizeType).addObj("optimizeTriangle", (Object)this.optimizeTriangle, (Object)ScooterPreferences.DEFAULT.optimizeTriangle).toString();
    }

    public static class Builder {
        private final ScooterPreferences original;
        private double speed;
        private double reluctance;
        private VehicleRentalPreferences rental;
        private VehicleRoutingOptimizeType optimizeType;
        private TimeSlopeSafetyTriangle optimizeTriangle;

        public Builder(ScooterPreferences original) {
            this.original = original;
            this.speed = original.speed;
            this.reluctance = original.reluctance;
            this.rental = original.rental;
            this.optimizeType = original.optimizeType;
            this.optimizeTriangle = original.optimizeTriangle;
        }

        public ScooterPreferences original() {
            return this.original;
        }

        public double speed() {
            return this.speed;
        }

        public Builder withSpeed(double speed) {
            this.speed = speed;
            return this;
        }

        public double reluctance() {
            return this.reluctance;
        }

        public Builder withReluctance(double reluctance) {
            this.reluctance = reluctance;
            return this;
        }

        public Builder withRental(Consumer<VehicleRentalPreferences.Builder> body) {
            this.rental = ((VehicleRentalPreferences)ObjectUtils.ifNotNull((Object)this.rental, (Object)this.original.rental)).copyOf().apply(body).build();
            return this;
        }

        public VehicleRoutingOptimizeType optimizeType() {
            return this.optimizeType;
        }

        public Builder withOptimizeType(VehicleRoutingOptimizeType optimizeType) {
            this.optimizeType = optimizeType;
            return this;
        }

        public TimeSlopeSafetyTriangle optimizeTriangle() {
            return this.optimizeTriangle;
        }

        public Builder withForcedOptimizeTriangle(Consumer<TimeSlopeSafetyTriangle.Builder> body) {
            TimeSlopeSafetyTriangle.Builder builder = TimeSlopeSafetyTriangle.of();
            body.accept(builder);
            this.optimizeTriangle = builder.buildOrDefault(this.optimizeTriangle);
            if (!builder.isEmpty()) {
                this.optimizeType = VehicleRoutingOptimizeType.TRIANGLE;
            }
            return this;
        }

        public Builder withOptimizeTriangle(Consumer<TimeSlopeSafetyTriangle.Builder> body) {
            TimeSlopeSafetyTriangle.Builder builder = TimeSlopeSafetyTriangle.of();
            body.accept(builder);
            this.optimizeTriangle = builder.buildOrDefault(this.optimizeTriangle);
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public ScooterPreferences build() {
            ScooterPreferences value = new ScooterPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

