/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.util.Locale;
import java.util.function.Consumer;
import org.opentripplanner.routing.api.request.preference.BikePreferences;
import org.opentripplanner.routing.api.request.preference.CarPreferences;
import org.opentripplanner.routing.api.request.preference.ItineraryFilterPreferences;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.request.preference.ScooterPreferences;
import org.opentripplanner.routing.api.request.preference.StreetPreferences;
import org.opentripplanner.routing.api.request.preference.SystemPreferences;
import org.opentripplanner.routing.api.request.preference.TransferPreferences;
import org.opentripplanner.routing.api.request.preference.TransitPreferences;
import org.opentripplanner.routing.api.request.preference.WalkPreferences;
import org.opentripplanner.routing.api.request.preference.WheelchairPreferences;
import org.opentripplanner.utils.lang.ObjectUtils;

public class RoutingPreferencesBuilder {
    private final RoutingPreferences original;
    private TransitPreferences transit = null;
    private TransferPreferences transfer = null;
    private WalkPreferences walk = null;
    private StreetPreferences street = null;
    private WheelchairPreferences wheelchair = null;
    private BikePreferences bike = null;
    private CarPreferences car = null;
    private ScooterPreferences scooter = null;
    private SystemPreferences system = null;
    private ItineraryFilterPreferences itineraryFilter = null;
    private Locale locale = null;

    public RoutingPreferencesBuilder(RoutingPreferences original) {
        this.original = original;
    }

    public RoutingPreferences original() {
        return this.original;
    }

    public TransitPreferences transit() {
        return this.transit == null ? this.original.transit() : this.transit;
    }

    public RoutingPreferencesBuilder withTransit(Consumer<TransitPreferences.Builder> body) {
        this.transit = ((TransitPreferences)ObjectUtils.ifNotNull((Object)this.transit, (Object)this.original.transit())).copyOf().apply(body).build();
        return this;
    }

    public TransferPreferences transfer() {
        return this.transfer == null ? this.original.transfer() : this.transfer;
    }

    public RoutingPreferencesBuilder withTransfer(Consumer<TransferPreferences.Builder> body) {
        this.transfer = ((TransferPreferences)ObjectUtils.ifNotNull((Object)this.transfer, (Object)this.original.transfer())).copyOf().apply(body).build();
        return this;
    }

    public WalkPreferences walk() {
        return this.walk == null ? this.original.walk() : this.walk;
    }

    public RoutingPreferencesBuilder withWalk(Consumer<WalkPreferences.Builder> body) {
        this.walk = ((WalkPreferences)ObjectUtils.ifNotNull((Object)this.walk, (Object)this.original.walk())).copyOf().apply(body).build();
        return this;
    }

    public StreetPreferences street() {
        return this.street == null ? this.original.street() : this.street;
    }

    public RoutingPreferencesBuilder withStreet(Consumer<StreetPreferences.Builder> body) {
        this.street = ((StreetPreferences)ObjectUtils.ifNotNull((Object)this.street, (Object)this.original.street())).copyOf().apply(body).build();
        return this;
    }

    public WheelchairPreferences wheelchair() {
        return this.wheelchair == null ? this.original.wheelchair() : this.wheelchair;
    }

    public RoutingPreferencesBuilder withWheelchair(WheelchairPreferences wheelchair) {
        this.wheelchair = wheelchair;
        return this;
    }

    public RoutingPreferencesBuilder withWheelchair(Consumer<WheelchairPreferences.Builder> body) {
        this.wheelchair = ((WheelchairPreferences)ObjectUtils.ifNotNull((Object)this.wheelchair, (Object)this.original.wheelchair())).copyOf().apply(body).build();
        return this;
    }

    public BikePreferences bike() {
        return this.bike == null ? this.original.bike() : this.bike;
    }

    public RoutingPreferencesBuilder withBike(Consumer<BikePreferences.Builder> body) {
        this.bike = ((BikePreferences)ObjectUtils.ifNotNull((Object)this.bike, (Object)this.original.bike())).copyOf().apply(body).build();
        return this;
    }

    public CarPreferences car() {
        return this.car == null ? this.original.car() : this.car;
    }

    public RoutingPreferencesBuilder withCar(Consumer<CarPreferences.Builder> body) {
        this.car = ((CarPreferences)ObjectUtils.ifNotNull((Object)this.car, (Object)this.original.car())).copyOf().apply(body).build();
        return this;
    }

    public ScooterPreferences scooter() {
        return this.scooter == null ? this.original.scooter() : this.scooter;
    }

    public RoutingPreferencesBuilder withScooter(Consumer<ScooterPreferences.Builder> body) {
        this.scooter = ((ScooterPreferences)ObjectUtils.ifNotNull((Object)this.scooter, (Object)this.original.scooter())).copyOf().apply(body).build();
        return this;
    }

    public SystemPreferences system() {
        return this.system == null ? this.original.system() : this.system;
    }

    public RoutingPreferencesBuilder withSystem(Consumer<SystemPreferences.Builder> body) {
        this.system = ((SystemPreferences)ObjectUtils.ifNotNull((Object)this.system, (Object)this.original.system())).copyOf().apply(body).build();
        return this;
    }

    public ItineraryFilterPreferences itineraryFilter() {
        return this.itineraryFilter == null ? this.original.itineraryFilter() : this.itineraryFilter;
    }

    public RoutingPreferencesBuilder withItineraryFilter(Consumer<ItineraryFilterPreferences.Builder> body) {
        this.itineraryFilter = ((ItineraryFilterPreferences)ObjectUtils.ifNotNull((Object)this.itineraryFilter, (Object)this.original.itineraryFilter())).copyOf().apply(body).build();
        return this;
    }

    public Locale locale() {
        return this.locale == null ? this.original.locale() : this.locale;
    }

    public RoutingPreferencesBuilder withLocale(Locale locale) {
        this.locale = (Locale)ObjectUtils.ifNotNull((Object)locale, (Object)this.original.locale());
        return this;
    }

    public RoutingPreferencesBuilder apply(Consumer<RoutingPreferencesBuilder> body) {
        body.accept(this);
        return this;
    }

    public RoutingPreferences build() {
        RoutingPreferences value = new RoutingPreferences(this);
        return this.original.equals(value) ? this.original : value;
    }
}

