/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.BikePreferences;
import org.opentripplanner.routing.api.request.preference.CarPreferences;
import org.opentripplanner.routing.api.request.preference.ItineraryFilterPreferences;
import org.opentripplanner.routing.api.request.preference.RoutingPreferencesBuilder;
import org.opentripplanner.routing.api.request.preference.ScooterPreferences;
import org.opentripplanner.routing.api.request.preference.StreetPreferences;
import org.opentripplanner.routing.api.request.preference.SystemPreferences;
import org.opentripplanner.routing.api.request.preference.TransferPreferences;
import org.opentripplanner.routing.api.request.preference.TransitPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleParkingPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;
import org.opentripplanner.routing.api.request.preference.WalkPreferences;
import org.opentripplanner.routing.api.request.preference.WheelchairPreferences;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class RoutingPreferences
implements Serializable {
    private static final Locale DEFAULT_LOCALE = new Locale("en", "US");
    public static final RoutingPreferences DEFAULT = new RoutingPreferences();
    private final TransitPreferences transit;
    private final TransferPreferences transfer;
    private final WalkPreferences walk;
    private final StreetPreferences street;
    private final WheelchairPreferences wheelchair;
    private final BikePreferences bike;
    private final CarPreferences car;
    private final ScooterPreferences scooter;
    private final SystemPreferences system;
    private final ItineraryFilterPreferences itineraryFilter;
    private final Locale locale;

    private RoutingPreferences() {
        this.transit = TransitPreferences.DEFAULT;
        this.transfer = TransferPreferences.DEFAULT;
        this.walk = WalkPreferences.DEFAULT;
        this.street = StreetPreferences.DEFAULT;
        this.wheelchair = WheelchairPreferences.DEFAULT;
        this.bike = BikePreferences.DEFAULT;
        this.car = CarPreferences.DEFAULT;
        this.scooter = ScooterPreferences.DEFAULT;
        this.system = SystemPreferences.DEFAULT;
        this.itineraryFilter = ItineraryFilterPreferences.DEFAULT;
        this.locale = DEFAULT_LOCALE;
    }

    RoutingPreferences(RoutingPreferencesBuilder builder) {
        this.transit = Objects.requireNonNull(builder.transit());
        this.transfer = Objects.requireNonNull(builder.transfer());
        this.walk = Objects.requireNonNull(builder.walk());
        this.wheelchair = Objects.requireNonNull(builder.wheelchair());
        this.street = Objects.requireNonNull(builder.street());
        this.bike = Objects.requireNonNull(builder.bike());
        this.car = Objects.requireNonNull(builder.car());
        this.scooter = Objects.requireNonNull(builder.scooter());
        this.system = Objects.requireNonNull(builder.system());
        this.itineraryFilter = Objects.requireNonNull(builder.itineraryFilter());
        this.locale = Objects.requireNonNull(builder.locale());
    }

    public static RoutingPreferencesBuilder of() {
        return DEFAULT.copyOf();
    }

    public RoutingPreferencesBuilder copyOf() {
        return new RoutingPreferencesBuilder(this);
    }

    public TransitPreferences transit() {
        return this.transit;
    }

    public TransferPreferences transfer() {
        return this.transfer;
    }

    public WalkPreferences walk() {
        return this.walk;
    }

    public StreetPreferences street() {
        return this.street;
    }

    public WheelchairPreferences wheelchair() {
        return this.wheelchair;
    }

    public BikePreferences bike() {
        return this.bike;
    }

    public CarPreferences car() {
        return this.car;
    }

    public ScooterPreferences scooter() {
        return this.scooter;
    }

    public VehicleParkingPreferences parking(TraverseMode mode) {
        return mode == TraverseMode.CAR ? this.car.parking() : this.bike.parking();
    }

    public VehicleRentalPreferences rental(TraverseMode mode) {
        return switch (mode) {
            case TraverseMode.BICYCLE -> this.bike.rental();
            case TraverseMode.CAR -> this.car.rental();
            case TraverseMode.SCOOTER -> this.scooter.rental();
            default -> throw new IllegalArgumentException("rental(): Invalid mode " + String.valueOf((Object)mode));
        };
    }

    @Nullable
    public VehicleRentalPreferences rental(StreetMode mode) {
        return switch (mode) {
            case StreetMode.BIKE_RENTAL -> this.bike.rental();
            case StreetMode.CAR_RENTAL -> this.car.rental();
            case StreetMode.SCOOTER_RENTAL -> this.scooter.rental();
            default -> null;
        };
    }

    public ItineraryFilterPreferences itineraryFilter() {
        return this.itineraryFilter;
    }

    public SystemPreferences system() {
        return this.system;
    }

    public Locale locale() {
        return this.locale;
    }

    public double getSpeed(TraverseMode mode, boolean walkingBike) {
        return switch (mode) {
            case TraverseMode.WALK -> {
                if (walkingBike) {
                    yield this.bike.walking().speed();
                }
                yield this.walk.speed();
            }
            case TraverseMode.BICYCLE -> this.bike.speed();
            case TraverseMode.SCOOTER -> this.scooter.speed();
            default -> throw new IllegalArgumentException("getSpeed(): Invalid mode " + String.valueOf((Object)mode));
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingPreferences that = (RoutingPreferences)o;
        return Objects.equals(this.transit, that.transit) && Objects.equals(this.transfer, that.transfer) && Objects.equals(this.walk, that.walk) && Objects.equals(this.street, that.street) && Objects.equals(this.wheelchair, that.wheelchair) && Objects.equals(this.bike, that.bike) && Objects.equals(this.car, that.car) && Objects.equals(this.scooter, that.scooter) && Objects.equals(this.system, that.system) && Objects.equals(this.itineraryFilter, that.itineraryFilter) && Objects.equals(this.locale, that.locale);
    }

    public int hashCode() {
        return Objects.hash(this.transit, this.transfer, this.walk, this.street, this.wheelchair, this.bike, this.car, this.scooter, this.system, this.itineraryFilter, this.locale);
    }

    public String toString() {
        return ToStringBuilder.of(RoutingPreferences.class).addObj("transit", (Object)this.transit, (Object)RoutingPreferences.DEFAULT.transit).addObj("transfer", (Object)this.transfer, (Object)RoutingPreferences.DEFAULT.transfer).addObj("walk", (Object)this.walk, (Object)RoutingPreferences.DEFAULT.walk).addObj("street", (Object)this.street, (Object)RoutingPreferences.DEFAULT.street).addObj("wheelchair", (Object)this.wheelchair, (Object)RoutingPreferences.DEFAULT.wheelchair).addObj("bike", (Object)this.bike, (Object)RoutingPreferences.DEFAULT.bike).addObj("car", (Object)this.car, (Object)RoutingPreferences.DEFAULT.car).addObj("scooter", (Object)this.scooter, (Object)RoutingPreferences.DEFAULT.scooter).addObj("system", (Object)this.system, (Object)RoutingPreferences.DEFAULT.system).addObj("itineraryFilter", (Object)this.itineraryFilter, (Object)RoutingPreferences.DEFAULT.itineraryFilter).addObj("locale", (Object)this.locale, (Object)DEFAULT_LOCALE).toString();
    }
}

