/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.util.Locale;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.lang.IntUtils;

public record Relax(double ratio, int slack) {
    public static final Relax NORMAL = new Relax(1.0, 0);

    public Relax {
        ratio = DoubleUtils.roundTo2Decimals((double)ratio);
        DoubleUtils.requireInRange((double)ratio, (double)1.0, (double)4.0, (String)"ratio");
        IntUtils.requireNotNegative((int)slack, (String)"slack");
    }

    public boolean hasNoEffect() {
        return NORMAL.equals(this);
    }

    public boolean hasEffect() {
        return !this.hasNoEffect();
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "%d + %.2f * x", this.slack, this.ratio);
    }
}

