/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.utils.lang.IntUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class MaxStopCountLimit {
    private static final int DEFAULT_LIMIT = 500;
    private static final Map<StreetMode, Integer> DEFAULT_FOR_MODES = Map.of();
    public static final MaxStopCountLimit DEFAULT = new MaxStopCountLimit();
    private final int defaultLimit;
    private final Map<StreetMode, Integer> limitsForModes;

    public MaxStopCountLimit() {
        this.defaultLimit = 500;
        this.limitsForModes = DEFAULT_FOR_MODES;
    }

    MaxStopCountLimit(Builder builder) {
        this.defaultLimit = IntUtils.requireNotNegative((int)builder.defaultLimit());
        this.limitsForModes = builder.copyCustomLimits();
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public int limitForMode(StreetMode mode) {
        return this.limitsForModes.getOrDefault(mode, this.defaultLimit);
    }

    public int defaultLimit() {
        return this.defaultLimit;
    }

    public String toString() {
        return ToStringBuilder.of(MaxStopCountLimit.class).addNum("defaultLimit", (Number)this.defaultLimit, (Number)500).addObj("limitsForModes", this.limitsForModes, DEFAULT_FOR_MODES).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaxStopCountLimit that = (MaxStopCountLimit)o;
        return this.defaultLimit == that.defaultLimit && this.limitsForModes.equals(that.limitsForModes);
    }

    public int hashCode() {
        return Objects.hash(this.defaultLimit, this.limitsForModes);
    }

    private Map<StreetMode, Integer> limitsForModes() {
        return this.limitsForModes;
    }

    private boolean hasCustomLimit(StreetMode mode) {
        return this.limitsForModes.containsKey(mode);
    }

    public static class Builder {
        private final MaxStopCountLimit original;
        private int defaultLimit;
        private Map<StreetMode, Integer> limitsForModes = null;

        Builder(MaxStopCountLimit original) {
            this.original = original;
            this.defaultLimit = original.defaultLimit();
        }

        int defaultLimit() {
            return this.defaultLimit;
        }

        public Builder withDefaultLimit(int defaultLimit) {
            this.defaultLimit = defaultLimit;
            return this;
        }

        public Builder with(StreetMode mode, Integer limit) {
            if (this.limitsForModes == null) {
                this.limitsForModes = new EnumMap<StreetMode, Integer>(StreetMode.class);
                for (StreetMode it : StreetMode.values()) {
                    if (!this.original.hasCustomLimit(it)) continue;
                    this.limitsForModes.put(it, this.original.limitForMode(it));
                }
            }
            this.limitsForModes.put(mode, limit);
            return this;
        }

        public Builder withLimitsForModes(Map<StreetMode, Integer> limitsForModes) {
            for (Map.Entry<StreetMode, Integer> e : limitsForModes.entrySet()) {
                this.with(e.getKey(), e.getValue());
            }
            return this;
        }

        Map<StreetMode, Integer> copyCustomLimits() {
            if (this.limitsForModes == null) {
                return this.original.limitsForModes();
            }
            EnumMap<StreetMode, Integer> copy = new EnumMap<StreetMode, Integer>(StreetMode.class);
            for (Map.Entry<StreetMode, Integer> it : this.limitsForModes.entrySet()) {
                if (this.defaultLimit == it.getValue()) continue;
                copy.put(it.getKey(), it.getValue());
            }
            return copy;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public MaxStopCountLimit build() {
            MaxStopCountLimit it = new MaxStopCountLimit(this);
            if (this.original != null && this.original.equals(it)) {
                return this.original;
            }
            return it;
        }
    }
}

