/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import org.opentripplanner.framework.doc.DocumentedEnum;

public enum ItineraryFilterDebugProfile implements DocumentedEnum<ItineraryFilterDebugProfile>
{
    OFF("By default, the debug itinerary filters is turned off."),
    LIST_ALL("List all itineraries, including all deleted itineraries."),
    LIMIT_TO_SEARCH_WINDOW("Return all itineraries, including deleted ones, inside the actual search-window used\n(the requested search-window may differ)."),
    LIMIT_TO_NUM_OF_ITINERARIES("Only return the requested number of itineraries, counting both actual and deleted ones.\nThe top `numItineraries` using the request sort order is returned. This does not work\nwith paging, itineraries after the limit, but inside the search-window are skipped when\nmoving to the next page.");

    private final String description;

    private ItineraryFilterDebugProfile(String description) {
        this.description = description.stripIndent().trim();
    }

    public boolean debugEnabled() {
        return this != OFF;
    }

    public static ItineraryFilterDebugProfile ofDebugEnabled(boolean enabled) {
        return enabled ? LIST_ALL : OFF;
    }

    @Override
    public String typeDescription() {
        return "Enable this to attach a system notice to itineraries instead of removing them. This is very\nconvenient when tuning the itinerary-filter-chain.";
    }

    @Override
    public String enumValueDescription() {
        return this.description;
    }
}

