/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class EscalatorPreferences
implements Serializable {
    public static final EscalatorPreferences DEFAULT = new EscalatorPreferences();
    private final double reluctance;
    private final double speed;
    private static final double HORIZONTAL_SPEED = 0.45;

    private EscalatorPreferences() {
        this.reluctance = 1.5;
        this.speed = 0.45;
    }

    private EscalatorPreferences(Builder builder) {
        this.reluctance = builder.reluctance;
        this.speed = builder.speed;
    }

    public static Builder of() {
        return new Builder(DEFAULT);
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public double reluctance() {
        return this.reluctance;
    }

    public double speed() {
        return this.speed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EscalatorPreferences that = (EscalatorPreferences)o;
        return DoubleUtils.doubleEquals((double)that.reluctance, (double)this.reluctance) && DoubleUtils.doubleEquals((double)that.speed, (double)this.speed);
    }

    public int hashCode() {
        return Objects.hash(this.speed, this.reluctance);
    }

    public String toString() {
        return ToStringBuilder.of(EscalatorPreferences.class).addNum("speed", (Number)this.speed, (Number)EscalatorPreferences.DEFAULT.speed).addNum("reluctance", (Number)this.reluctance, (Number)EscalatorPreferences.DEFAULT.reluctance).toString();
    }

    public static class Builder {
        private final EscalatorPreferences original;
        private double reluctance;
        private double speed;

        public Builder(EscalatorPreferences original) {
            this.original = original;
            this.reluctance = original.reluctance;
            this.speed = original.speed;
        }

        public EscalatorPreferences original() {
            return this.original;
        }

        public double speed() {
            return this.speed;
        }

        public Builder withSpeed(double speed) {
            this.speed = speed;
            return this;
        }

        public double reluctance() {
            return this.reluctance;
        }

        public Builder withReluctance(double reluctance) {
            this.reluctance = reluctance;
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public EscalatorPreferences build() {
            EscalatorPreferences newObj = new EscalatorPreferences(this);
            return this.original.equals(newObj) ? this.original : newObj;
        }
    }
}

