/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.framework.model.Units;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class ElevatorPreferences
implements Serializable {
    public static final ElevatorPreferences DEFAULT = new ElevatorPreferences();
    private final Cost boardCost;
    private final int boardTime;
    private final Cost hopCost;
    private final int hopTime;

    private ElevatorPreferences() {
        this.boardCost = Cost.costOfSeconds(90);
        this.boardTime = 90;
        this.hopCost = Cost.costOfSeconds(20);
        this.hopTime = 20;
    }

    private ElevatorPreferences(Builder builder) {
        this.boardCost = builder.boardCost;
        this.boardTime = Units.duration(builder.boardTime);
        this.hopCost = builder.hopCost;
        this.hopTime = Units.duration(builder.hopTime);
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public int boardCost() {
        return this.boardCost.toSeconds();
    }

    public int boardTime() {
        return this.boardTime;
    }

    public int hopCost() {
        return this.hopCost.toSeconds();
    }

    public int hopTime() {
        return this.hopTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElevatorPreferences that = (ElevatorPreferences)o;
        return this.boardCost.equals(that.boardCost) && this.boardTime == that.boardTime && this.hopTime == that.hopTime && this.hopCost.equals(that.hopCost);
    }

    public int hashCode() {
        return Objects.hash(this.boardCost, this.boardTime, this.hopTime, this.hopCost);
    }

    public String toString() {
        return ToStringBuilder.of(ElevatorPreferences.class).addObj("boardCost", (Object)this.boardCost, (Object)ElevatorPreferences.DEFAULT.boardCost).addDurationSec("boardTime", Integer.valueOf(this.boardTime), Integer.valueOf(ElevatorPreferences.DEFAULT.boardTime)).addObj("hopCost", (Object)this.hopCost, (Object)ElevatorPreferences.DEFAULT.hopCost).addDurationSec("hopTime", Integer.valueOf(this.hopTime), Integer.valueOf(ElevatorPreferences.DEFAULT.hopTime)).toString();
    }

    public static class Builder {
        private final ElevatorPreferences original;
        private Cost boardCost;
        private int boardTime;
        private int hopTime;
        private Cost hopCost;

        public Builder(ElevatorPreferences original) {
            this.original = original;
            this.boardCost = original.boardCost;
            this.boardTime = original.boardTime;
            this.hopCost = original.hopCost;
            this.hopTime = original.hopTime;
        }

        public ElevatorPreferences original() {
            return this.original;
        }

        public Builder withBoardCost(int boardCost) {
            this.boardCost = Cost.costOfSeconds(boardCost);
            return this;
        }

        public Builder withBoardTime(int boardTime) {
            this.boardTime = boardTime;
            return this;
        }

        public Builder withHopTime(int hopTime) {
            this.hopTime = hopTime;
            return this;
        }

        public Builder withHopCost(int hopCost) {
            this.hopCost = Cost.costOfSeconds(hopCost);
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        ElevatorPreferences build() {
            ElevatorPreferences value = new ElevatorPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

