/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.framework.model.Units;
import org.opentripplanner.routing.api.request.preference.VehicleParkingPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.lang.ObjectUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class CarPreferences
implements Serializable {
    public static final CarPreferences DEFAULT = new CarPreferences();
    private final double reluctance;
    private final Cost boardCost;
    private final VehicleParkingPreferences parking;
    private final VehicleRentalPreferences rental;
    private final Duration pickupTime;
    private final Cost pickupCost;
    private final double accelerationSpeed;
    private final double decelerationSpeed;

    private CarPreferences() {
        this.reluctance = 2.0;
        this.boardCost = Cost.costOfMinutes(10);
        this.parking = VehicleParkingPreferences.DEFAULT;
        this.rental = VehicleRentalPreferences.DEFAULT;
        this.pickupTime = Duration.ofMinutes(1L);
        this.pickupCost = Cost.costOfMinutes(2);
        this.accelerationSpeed = 2.9;
        this.decelerationSpeed = 2.9;
    }

    private CarPreferences(Builder builder) {
        this.reluctance = Units.reluctance(builder.reluctance);
        this.boardCost = builder.boardCost;
        this.parking = builder.parking;
        this.rental = builder.rental;
        this.pickupTime = Duration.ofSeconds(Units.duration(builder.pickupTime));
        this.pickupCost = builder.pickupCost;
        this.accelerationSpeed = Units.acceleration(builder.accelerationSpeed);
        this.decelerationSpeed = Units.acceleration(builder.decelerationSpeed);
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public double reluctance() {
        return this.reluctance;
    }

    public int boardCost() {
        return this.boardCost.toSeconds();
    }

    public VehicleParkingPreferences parking() {
        return this.parking;
    }

    public VehicleRentalPreferences rental() {
        return this.rental;
    }

    public Duration pickupTime() {
        return this.pickupTime;
    }

    public Cost pickupCost() {
        return this.pickupCost;
    }

    public double accelerationSpeed() {
        return this.accelerationSpeed;
    }

    public double decelerationSpeed() {
        return this.decelerationSpeed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CarPreferences that = (CarPreferences)o;
        return DoubleUtils.doubleEquals((double)that.reluctance, (double)this.reluctance) && this.boardCost.equals(that.boardCost) && this.parking.equals(that.parking) && this.rental.equals(that.rental) && Objects.equals(this.pickupTime, that.pickupTime) && this.pickupCost.equals(that.pickupCost) && DoubleUtils.doubleEquals((double)that.accelerationSpeed, (double)this.accelerationSpeed) && DoubleUtils.doubleEquals((double)that.decelerationSpeed, (double)this.decelerationSpeed);
    }

    public int hashCode() {
        return Objects.hash(this.reluctance, this.boardCost, this.parking, this.rental, this.pickupTime, this.pickupCost, this.accelerationSpeed, this.decelerationSpeed);
    }

    public String toString() {
        return ToStringBuilder.of(CarPreferences.class).addNum("reluctance", (Number)this.reluctance, (Number)CarPreferences.DEFAULT.reluctance).addObj("boardCost", (Object)this.boardCost, (Object)CarPreferences.DEFAULT.boardCost).addObj("parking", (Object)this.parking, (Object)CarPreferences.DEFAULT.parking).addObj("rental", (Object)this.rental, (Object)CarPreferences.DEFAULT.rental).addObj("pickupTime", (Object)this.pickupTime, (Object)CarPreferences.DEFAULT.pickupTime).addObj("pickupCost", (Object)this.pickupCost, (Object)CarPreferences.DEFAULT.pickupCost).addNum("accelerationSpeed", (Number)this.accelerationSpeed, (Number)CarPreferences.DEFAULT.accelerationSpeed).addNum("decelerationSpeed", (Number)this.decelerationSpeed, (Number)CarPreferences.DEFAULT.decelerationSpeed).toString();
    }

    public static class Builder {
        private final CarPreferences original;
        private double reluctance;
        private Cost boardCost;
        private VehicleParkingPreferences parking;
        private VehicleRentalPreferences rental;
        private int pickupTime;
        private Cost pickupCost;
        private double accelerationSpeed;
        private double decelerationSpeed;

        public Builder(CarPreferences original) {
            this.original = original;
            this.reluctance = original.reluctance;
            this.boardCost = original.boardCost;
            this.parking = original.parking;
            this.rental = original.rental;
            this.pickupTime = (int)original.pickupTime.toSeconds();
            this.pickupCost = original.pickupCost;
            this.accelerationSpeed = original.accelerationSpeed;
            this.decelerationSpeed = original.decelerationSpeed;
        }

        public CarPreferences original() {
            return this.original;
        }

        public Builder withReluctance(double reluctance) {
            this.reluctance = reluctance;
            return this;
        }

        public Cost boardCost() {
            return this.boardCost;
        }

        public Builder withBoardCost(int boardCost) {
            this.boardCost = Cost.costOfSeconds(boardCost);
            return this;
        }

        public Builder withParking(Consumer<VehicleParkingPreferences.Builder> body) {
            this.parking = ((VehicleParkingPreferences)ObjectUtils.ifNotNull((Object)this.parking, (Object)this.original.parking)).copyOf().apply(body).build();
            return this;
        }

        public Builder withRental(Consumer<VehicleRentalPreferences.Builder> body) {
            this.rental = ((VehicleRentalPreferences)ObjectUtils.ifNotNull((Object)this.rental, (Object)this.original.rental)).copyOf().apply(body).build();
            return this;
        }

        public Builder withPickupTime(Duration pickupTime) {
            this.pickupTime = (int)pickupTime.toSeconds();
            return this;
        }

        public Builder withPickupCost(int pickupCost) {
            this.pickupCost = Cost.costOfSeconds(pickupCost);
            return this;
        }

        public Builder withAccelerationSpeed(double accelerationSpeed) {
            this.accelerationSpeed = accelerationSpeed;
            return this;
        }

        public Builder withDecelerationSpeed(double decelerationSpeed) {
            this.decelerationSpeed = decelerationSpeed;
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public CarPreferences build() {
            CarPreferences value = new CarPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

