/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.framework.model.Units;
import org.opentripplanner.routing.api.request.preference.TimeSlopeSafetyTriangle;
import org.opentripplanner.routing.api.request.preference.VehicleParkingPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleWalkingPreferences;
import org.opentripplanner.routing.core.VehicleRoutingOptimizeType;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.lang.ObjectUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class BikePreferences
implements Serializable {
    public static final BikePreferences DEFAULT = new BikePreferences();
    private final double speed;
    private final double reluctance;
    private final Cost boardCost;
    private final VehicleParkingPreferences parking;
    private final VehicleRentalPreferences rental;
    private final VehicleRoutingOptimizeType optimizeType;
    private final TimeSlopeSafetyTriangle optimizeTriangle;
    private final VehicleWalkingPreferences walking;

    private BikePreferences() {
        this.speed = 5.0;
        this.reluctance = 2.0;
        this.boardCost = Cost.costOfMinutes(10);
        this.parking = VehicleParkingPreferences.DEFAULT;
        this.rental = VehicleRentalPreferences.DEFAULT;
        this.optimizeType = VehicleRoutingOptimizeType.SAFE_STREETS;
        this.optimizeTriangle = TimeSlopeSafetyTriangle.DEFAULT;
        this.walking = VehicleWalkingPreferences.DEFAULT;
    }

    private BikePreferences(Builder builder) {
        this.speed = Units.speed(builder.speed);
        this.reluctance = Units.reluctance(builder.reluctance);
        this.boardCost = builder.boardCost;
        this.parking = builder.parking;
        this.rental = builder.rental;
        this.optimizeType = Objects.requireNonNull(builder.optimizeType);
        this.optimizeTriangle = Objects.requireNonNull(builder.optimizeTriangle);
        this.walking = builder.walking;
    }

    public static Builder of() {
        return new Builder(DEFAULT);
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public double speed() {
        return this.speed;
    }

    public double reluctance() {
        return this.reluctance;
    }

    public int boardCost() {
        return this.boardCost.toSeconds();
    }

    public VehicleParkingPreferences parking() {
        return this.parking;
    }

    public VehicleRentalPreferences rental() {
        return this.rental;
    }

    public VehicleRoutingOptimizeType optimizeType() {
        return this.optimizeType;
    }

    public TimeSlopeSafetyTriangle optimizeTriangle() {
        return this.optimizeTriangle;
    }

    public VehicleWalkingPreferences walking() {
        return this.walking;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BikePreferences that = (BikePreferences)o;
        return DoubleUtils.doubleEquals((double)that.speed, (double)this.speed) && DoubleUtils.doubleEquals((double)that.reluctance, (double)this.reluctance) && this.boardCost.equals(that.boardCost) && Objects.equals(this.parking, that.parking) && Objects.equals(this.rental, that.rental) && this.optimizeType == that.optimizeType && this.optimizeTriangle.equals(that.optimizeTriangle) && Objects.equals(this.walking, that.walking);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.speed, this.reluctance, this.boardCost, this.parking, this.rental, this.optimizeType, this.optimizeTriangle, this.walking});
    }

    public String toString() {
        return ToStringBuilder.of(BikePreferences.class).addNum("speed", (Number)this.speed, (Number)BikePreferences.DEFAULT.speed).addNum("reluctance", (Number)this.reluctance, (Number)BikePreferences.DEFAULT.reluctance).addObj("boardCost", (Object)this.boardCost, (Object)BikePreferences.DEFAULT.boardCost).addObj("parking", (Object)this.parking, (Object)BikePreferences.DEFAULT.parking).addObj("rental", (Object)this.rental, (Object)BikePreferences.DEFAULT.rental).addEnum("optimizeType", (Enum)this.optimizeType, (Enum)BikePreferences.DEFAULT.optimizeType).addObj("optimizeTriangle", (Object)this.optimizeTriangle, (Object)BikePreferences.DEFAULT.optimizeTriangle).addObj("walking", (Object)this.walking, (Object)BikePreferences.DEFAULT.walking).toString();
    }

    public static class Builder {
        private final BikePreferences original;
        private double speed;
        private double reluctance;
        private Cost boardCost;
        private VehicleParkingPreferences parking;
        private VehicleRentalPreferences rental;
        private VehicleRoutingOptimizeType optimizeType;
        private TimeSlopeSafetyTriangle optimizeTriangle;
        private VehicleWalkingPreferences walking;

        public Builder(BikePreferences original) {
            this.original = original;
            this.speed = original.speed;
            this.reluctance = original.reluctance;
            this.boardCost = original.boardCost;
            this.parking = original.parking;
            this.rental = original.rental;
            this.optimizeType = original.optimizeType;
            this.optimizeTriangle = original.optimizeTriangle;
            this.walking = original.walking;
        }

        public BikePreferences original() {
            return this.original;
        }

        public double speed() {
            return this.speed;
        }

        public Builder withSpeed(double speed) {
            this.speed = speed;
            return this;
        }

        public double reluctance() {
            return this.reluctance;
        }

        public Builder withReluctance(double reluctance) {
            this.reluctance = reluctance;
            return this;
        }

        public Cost boardCost() {
            return this.boardCost;
        }

        public Builder withBoardCost(int boardCost) {
            this.boardCost = Cost.costOfSeconds(boardCost);
            return this;
        }

        public Builder withParking(Consumer<VehicleParkingPreferences.Builder> body) {
            this.parking = ((VehicleParkingPreferences)ObjectUtils.ifNotNull((Object)this.parking, (Object)this.original.parking)).copyOf().apply(body).build();
            return this;
        }

        public Builder withRental(Consumer<VehicleRentalPreferences.Builder> body) {
            this.rental = ((VehicleRentalPreferences)ObjectUtils.ifNotNull((Object)this.rental, (Object)this.original.rental)).copyOf().apply(body).build();
            return this;
        }

        public VehicleRoutingOptimizeType optimizeType() {
            return this.optimizeType;
        }

        public Builder withOptimizeType(VehicleRoutingOptimizeType optimizeType) {
            this.optimizeType = optimizeType;
            return this;
        }

        public TimeSlopeSafetyTriangle optimizeTriangle() {
            return this.optimizeTriangle;
        }

        public Builder withForcedOptimizeTriangle(Consumer<TimeSlopeSafetyTriangle.Builder> body) {
            TimeSlopeSafetyTriangle.Builder builder = TimeSlopeSafetyTriangle.of();
            body.accept(builder);
            this.optimizeTriangle = builder.buildOrDefault(this.optimizeTriangle);
            if (!builder.isEmpty()) {
                this.optimizeType = VehicleRoutingOptimizeType.TRIANGLE;
            }
            return this;
        }

        public Builder withOptimizeTriangle(Consumer<TimeSlopeSafetyTriangle.Builder> body) {
            TimeSlopeSafetyTriangle.Builder builder = TimeSlopeSafetyTriangle.of();
            body.accept(builder);
            this.optimizeTriangle = builder.buildOrDefault(this.optimizeTriangle);
            return this;
        }

        public Builder withWalking(Consumer<VehicleWalkingPreferences.Builder> body) {
            this.walking = ((VehicleWalkingPreferences)ObjectUtils.ifNotNull((Object)this.walking, (Object)this.original.walking)).copyOf().apply(body).build();
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public BikePreferences build() {
            BikePreferences value = new BikePreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

