/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class AccessibilityPreferences {
    private static final Cost NOT_SET = Cost.costOfSeconds(9999999);
    private static final AccessibilityPreferences DEFAULT_UNSET = new AccessibilityPreferences(false, NOT_SET, NOT_SET);
    private static final AccessibilityPreferences ONLY_CONSIDER_ACCESSIBLE = new AccessibilityPreferences(true, NOT_SET, NOT_SET);
    private final boolean onlyConsiderAccessible;
    private final Cost unknownCost;
    private final Cost inaccessibleCost;

    private AccessibilityPreferences(boolean onlyConsiderAccessible, Cost unknownCost, Cost inaccessibleCost) {
        this.onlyConsiderAccessible = onlyConsiderAccessible;
        this.unknownCost = unknownCost;
        this.inaccessibleCost = inaccessibleCost;
    }

    public static AccessibilityPreferences ofOnlyAccessible() {
        return ONLY_CONSIDER_ACCESSIBLE;
    }

    public static AccessibilityPreferences ofCost(int unknownCost, int inaccessibleCost) {
        return new AccessibilityPreferences(false, Cost.costOfSeconds(unknownCost), Cost.costOfSeconds(inaccessibleCost));
    }

    public static Builder of() {
        return DEFAULT_UNSET.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this, this);
    }

    public Builder copyOfWithDefaultCosts(AccessibilityPreferences defaultCosts) {
        return new Builder(this, defaultCosts);
    }

    public boolean onlyConsiderAccessible() {
        return this.onlyConsiderAccessible;
    }

    public int unknownCost() {
        return this.unknownCost.toSeconds();
    }

    public int inaccessibleCost() {
        return this.inaccessibleCost.toSeconds();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessibilityPreferences that = (AccessibilityPreferences)o;
        return this.onlyConsiderAccessible == that.onlyConsiderAccessible && Objects.equals(this.unknownCost, that.unknownCost) && Objects.equals(this.inaccessibleCost, that.inaccessibleCost);
    }

    public int hashCode() {
        return Objects.hash(this.onlyConsiderAccessible, this.unknownCost, this.inaccessibleCost);
    }

    public String toString() {
        return this.toString(DEFAULT_UNSET);
    }

    public String toString(AccessibilityPreferences defaultCosts) {
        if (this.onlyConsiderAccessible) {
            return "OnlyConsiderAccessible";
        }
        return ToStringBuilder.of(AccessibilityPreferences.class).addObj("unknownCost", (Object)this.unknownCost, (Object)defaultCosts.unknownCost).addObj("inaccessibleCost", (Object)this.inaccessibleCost, (Object)defaultCosts.inaccessibleCost).toString();
    }

    public static class Builder {
        private final AccessibilityPreferences original;
        private boolean onlyConsiderAccessible;
        private Cost unknownCost;
        private Cost inaccessibleCost;

        private Builder(AccessibilityPreferences original, AccessibilityPreferences defaultCosts) {
            this.original = original;
            if (original.onlyConsiderAccessible) {
                this.onlyConsiderAccessible = true;
                this.unknownCost = defaultCosts.unknownCost;
                this.inaccessibleCost = defaultCosts.inaccessibleCost;
            } else {
                this.onlyConsiderAccessible = false;
                this.unknownCost = original.unknownCost;
                this.inaccessibleCost = original.inaccessibleCost;
            }
        }

        public boolean onlyConsiderAccessible() {
            return this.onlyConsiderAccessible;
        }

        public Builder withAccessibleOnly() {
            this.onlyConsiderAccessible = true;
            return this;
        }

        public int unknownCost() {
            return this.unknownCost.toSeconds();
        }

        public Builder withUnknownCost(int unknownCost) {
            this.onlyConsiderAccessible = false;
            this.unknownCost = Cost.costOfSeconds(unknownCost);
            return this;
        }

        public int inaccessibleCost() {
            return this.inaccessibleCost.toSeconds();
        }

        public Builder withInaccessibleCost(int inaccessibleCost) {
            this.onlyConsiderAccessible = false;
            this.inaccessibleCost = Cost.costOfSeconds(inaccessibleCost);
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public AccessibilityPreferences build() {
            AccessibilityPreferences value = this.onlyConsiderAccessible ? AccessibilityPreferences.ofOnlyAccessible() : AccessibilityPreferences.ofCost(this.unknownCost.toSeconds(), this.inaccessibleCost.toSeconds());
            return this.original.equals(value) ? this.original : value;
        }
    }
}

