/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.framework.DurationForEnum;
import org.opentripplanner.routing.api.request.framework.TimeAndCostPenalty;
import org.opentripplanner.routing.api.request.framework.TimeAndCostPenaltyForEnum;
import org.opentripplanner.routing.api.request.framework.TimePenalty;
import org.opentripplanner.routing.api.request.preference.MaxStopCountLimit;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class AccessEgressPreferences
implements Serializable {
    private static final TimeAndCostPenaltyForEnum<StreetMode> DEFAULT_TIME_AND_COST = AccessEgressPreferences.createDefaultCarPenalty();
    public static final AccessEgressPreferences DEFAULT = new AccessEgressPreferences();
    private final TimeAndCostPenaltyForEnum<StreetMode> penalty;
    private final DurationForEnum<StreetMode> maxDuration;
    private final MaxStopCountLimit maxStopCountLimit;

    private AccessEgressPreferences() {
        this.maxDuration = AccessEgressPreferences.durationForStreetModeOf(Duration.ofMinutes(45L));
        this.penalty = DEFAULT_TIME_AND_COST;
        this.maxStopCountLimit = new MaxStopCountLimit();
    }

    private AccessEgressPreferences(Builder builder) {
        this.maxDuration = builder.maxDuration;
        this.penalty = builder.penalty;
        this.maxStopCountLimit = builder.maxStopCountLimit;
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public TimeAndCostPenaltyForEnum<StreetMode> penalty() {
        return this.penalty;
    }

    public DurationForEnum<StreetMode> maxDuration() {
        return this.maxDuration;
    }

    public MaxStopCountLimit maxStopCountLimit() {
        return this.maxStopCountLimit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessEgressPreferences that = (AccessEgressPreferences)o;
        return this.penalty.equals(that.penalty) && this.maxDuration.equals(that.maxDuration) && this.maxStopCountLimit.equals(that.maxStopCountLimit);
    }

    public int hashCode() {
        return Objects.hash(this.penalty, this.maxDuration, this.maxStopCountLimit);
    }

    public String toString() {
        return ToStringBuilder.of(AccessEgressPreferences.class).addObj("penalty", this.penalty, AccessEgressPreferences.DEFAULT.penalty).addObj("maxDuration", this.maxDuration, AccessEgressPreferences.DEFAULT.maxDuration).addObj("maxStopCount", (Object)this.maxStopCountLimit, (Object)AccessEgressPreferences.DEFAULT.maxStopCountLimit).toString();
    }

    private static DurationForEnum<StreetMode> durationForStreetModeOf(Duration defaultValue) {
        return DurationForEnum.of(StreetMode.class).withDefault(defaultValue).build();
    }

    private static TimeAndCostPenaltyForEnum<StreetMode> createDefaultCarPenalty() {
        TimeAndCostPenaltyForEnum.Builder<StreetMode> penaltyBuilder = TimeAndCostPenaltyForEnum.of(StreetMode.class);
        TimeAndCostPenalty flexDefaultPenalty = TimeAndCostPenalty.of(TimePenalty.of(Duration.ofMinutes(10L), 1.3f), 1.3);
        penaltyBuilder.with(StreetMode.FLEXIBLE, flexDefaultPenalty);
        TimeAndCostPenalty carPenalty = TimeAndCostPenalty.of(TimePenalty.of(Duration.ofMinutes(20L), 2.0), 1.5);
        for (StreetMode it : StreetMode.values()) {
            if (!it.includesDriving() || !it.accessAllowed() && !it.egressAllowed() || it == StreetMode.CAR) continue;
            penaltyBuilder.with(it, carPenalty);
        }
        return penaltyBuilder.build();
    }

    public static class Builder {
        private final AccessEgressPreferences original;
        private TimeAndCostPenaltyForEnum<StreetMode> penalty;
        private DurationForEnum<StreetMode> maxDuration;
        private MaxStopCountLimit maxStopCountLimit;

        public Builder(AccessEgressPreferences original) {
            this.original = original;
            this.maxDuration = original.maxDuration;
            this.penalty = original.penalty;
            this.maxStopCountLimit = original.maxStopCountLimit;
        }

        public Builder withMaxDuration(Consumer<DurationForEnum.Builder<StreetMode>> body) {
            this.maxDuration = this.maxDuration.copyOf().apply(body).build();
            return this;
        }

        public Builder withMaxDuration(Duration defaultValue, Map<StreetMode, Duration> values) {
            return this.withMaxDuration(b -> b.withDefault(defaultValue).withValues(values));
        }

        public Builder withMaxStopCount(Consumer<MaxStopCountLimit.Builder> body) {
            this.maxStopCountLimit = this.maxStopCountLimit.copyOf().apply(body).build();
            return this;
        }

        public Builder withMaxStopCount(int defaultMaxStopCount, Map<StreetMode, Integer> maxStopCountForMode) {
            return this.withMaxStopCount(b -> b.withDefaultLimit(defaultMaxStopCount).withLimitsForModes(maxStopCountForMode));
        }

        public Builder withPenalty(Consumer<TimeAndCostPenaltyForEnum.Builder<StreetMode>> body) {
            this.penalty = this.penalty.copyOf().apply(body).build();
            return this;
        }

        public Builder withPenalty(Map<StreetMode, TimeAndCostPenalty> values) {
            return this.withPenalty((TimeAndCostPenaltyForEnum.Builder<StreetMode> b) -> b.withValues(values));
        }

        public AccessEgressPreferences original() {
            return this.original;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        AccessEgressPreferences build() {
            AccessEgressPreferences value = new AccessEgressPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

