/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.framework;

import java.time.Duration;
import org.opentripplanner.routing.api.request.framework.AbstractLinearFunction;
import org.opentripplanner.routing.api.request.framework.LinearFunctionSerialization;
import org.opentripplanner.utils.lang.StringUtils;
import org.opentripplanner.utils.time.DurationUtils;

public final class TimePenalty
extends AbstractLinearFunction<Duration> {
    public static final TimePenalty ZERO = new TimePenalty(Duration.ZERO, 0.0);
    public static final TimePenalty NONE = new TimePenalty(Duration.ZERO, 1.0);

    private TimePenalty(Duration constant, double coefficient) {
        super(DurationUtils.requireNonNegative((Duration)constant), coefficient);
    }

    public static TimePenalty of(Duration constant, double coefficient) {
        return new TimePenalty(constant, coefficient);
    }

    public static TimePenalty of(String text) {
        if (StringUtils.hasNoValue((String)text)) {
            return ZERO;
        }
        return LinearFunctionSerialization.parse(text, TimePenalty::new).orElse(ZERO);
    }

    @Override
    protected boolean isZero(Duration value) {
        return value.isZero();
    }

    public boolean modifies() {
        return !((Duration)this.constant()).isZero() && this.coefficient() != 1.0;
    }

    @Override
    protected Duration constantAsDuration() {
        return (Duration)this.constant();
    }

    public Duration calculate(Duration time) {
        return ((Duration)this.constant()).plusSeconds(Math.round(this.coefficient() * (double)time.toSeconds()));
    }
}

