/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.framework;

import java.time.Duration;
import java.util.Objects;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.framework.model.TimeAndCost;
import org.opentripplanner.framework.model.Units;
import org.opentripplanner.routing.api.request.framework.TimePenalty;

public record TimeAndCostPenalty(TimePenalty timePenalty, double costFactor) {
    public static final TimeAndCostPenalty ZERO = new TimeAndCostPenalty(TimePenalty.ZERO, 0.0);

    public TimeAndCostPenalty {
        costFactor = Units.normalizedFactor(costFactor, 0.0, 10.0);
        timePenalty = Objects.requireNonNull(timePenalty);
        if (timePenalty.isZero() && costFactor != 0.0) {
            throw new IllegalArgumentException("When time-penalty is zero, the costFactor have no effect and should be zero as well.");
        }
    }

    public static TimeAndCostPenalty of(TimePenalty timePenalty, double costFactor) {
        return new TimeAndCostPenalty(timePenalty, costFactor);
    }

    public static TimeAndCostPenalty of(String timePenalty, double costFactor) {
        return TimeAndCostPenalty.of(TimePenalty.of(timePenalty), costFactor);
    }

    public TimeAndCost calculate(Duration time) {
        Duration timePenaltyValue = this.timePenalty.calculate(time);
        return new TimeAndCost(timePenaltyValue, Cost.costOfSeconds((double)timePenaltyValue.toSeconds() * this.costFactor));
    }

    public TimeAndCost calculate(int timeInSeconds) {
        return this.calculate(Duration.ofSeconds(timeInSeconds));
    }

    public boolean isEmpty() {
        return ZERO.equals(this);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("(timePenalty: " + String.valueOf(this.timePenalty));
        if (this.costFactor != 0.0) {
            buf.append(", costFactor: ").append(Units.factorToString(this.costFactor));
        }
        return buf.append(")").toString();
    }
}

