/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.framework;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.framework.model.Units;
import org.opentripplanner.routing.api.request.framework.AbstractLinearFunction;
import org.opentripplanner.utils.lang.IntUtils;
import org.opentripplanner.utils.lang.StringUtils;
import org.opentripplanner.utils.time.DurationUtils;

public class LinearFunctionSerialization {
    private static final String SEP = "\\s*";
    private static final String NUM = "([\\d.,]+)";
    private static final String DUR = "(?:PT)?([\\d\\.hms]+)";
    private static final String PLUS = Pattern.quote("+");
    private static final String VARIABLE = "[XxTt]";
    private static final Pattern PATTERN = Pattern.compile(String.join((CharSequence)"\\s*", "(?:PT)?([\\d\\.hms]+)", PLUS, "([\\d.,]+)", "[XxTt]"));
    private static final Pattern DECIMAL_NUMBER_PATTERN = Pattern.compile("\\d+(\\.\\d+)?");

    private LinearFunctionSerialization() {
    }

    public static <T> Optional<T> parse(String text, BiFunction<Duration, Double, T> factory) {
        if (StringUtils.hasNoValue((String)text)) {
            return Optional.empty();
        }
        Matcher m = PATTERN.matcher(text);
        if (m.matches()) {
            String constantText = m.group(1);
            String coefficientText = m.group(2);
            double coefficient = Double.parseDouble(coefficientText);
            coefficient = Units.normalizedFactor(coefficient, 0.0, 100.0);
            Duration constant = LinearFunctionSerialization.parseDecimalSecondsOrDuration(constantText);
            return Optional.of(factory.apply(constant, coefficient));
        }
        throw new IllegalArgumentException("Unable to parse function: '" + text + "'");
    }

    public static String serialize(AbstractLinearFunction<?> value) {
        return LinearFunctionSerialization.serialize(value.constantAsDuration(), value.coefficient());
    }

    public static String serialize(Duration constant, double coefficient) {
        return String.format(Locale.ROOT, "%s + %s t", DurationUtils.durationToStr((Duration)constant), Units.factorToString(coefficient));
    }

    private static Duration parseDecimalSecondsOrDuration(String text) {
        try {
            if (DECIMAL_NUMBER_PATTERN.matcher(text).matches()) {
                return Duration.ofSeconds(IntUtils.round((double)Double.parseDouble(text)));
            }
            return DurationUtils.duration((String)text);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Unable to parse duration: '" + text + "'");
        }
    }
}

