/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.framework;

import java.io.Serializable;
import java.time.Duration;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.utils.tostring.ValueObjectToStringBuilder;

public class DurationForEnum<E extends Enum<E>>
implements Serializable {
    private final Class<E> type;
    private final Duration defaultValue;
    private final Map<E, Duration> valueForEnum;

    public DurationForEnum(Class<E> type) {
        this.type = Objects.requireNonNull(type);
        this.defaultValue = Duration.ZERO;
        this.valueForEnum = Map.of();
    }

    DurationForEnum(Builder<E> builder) {
        this.type = Objects.requireNonNull(builder.type());
        this.defaultValue = Objects.requireNonNull(builder.defaultValue());
        this.valueForEnum = builder.copyValueForEnum();
    }

    public static <S extends Enum<S>> Builder<S> of(Class<S> type) {
        return new DurationForEnum<S>(type).copyOf();
    }

    public Builder<E> copyOf() {
        return new Builder(this);
    }

    Class<E> type() {
        return this.type;
    }

    public Duration defaultValue() {
        return this.defaultValue;
    }

    public int defaultValueSeconds() {
        return (int)this.defaultValue.toSeconds();
    }

    public Duration valueOf(E type) {
        return this.valueForEnum.getOrDefault(type, this.defaultValue);
    }

    public boolean isSet(E key) {
        return !this.defaultValue.equals(this.valueOf(key));
    }

    public String toString() {
        ValueObjectToStringBuilder builder = ValueObjectToStringBuilder.of().addText("DurationFor" + this.type.getSimpleName() + "{").addText("default:").addDuration(this.defaultValue);
        List<Map.Entry> sortedEntryList = this.valueForEnum.entrySet().stream().sorted(Comparator.comparingInt(e -> ((Enum)e.getKey()).ordinal())).toList();
        for (Map.Entry e2 : sortedEntryList) {
            if (this.defaultValue.equals(e2.getValue())) continue;
            builder.addText(", ").addText(((Enum)e2.getKey()).name()).addText(":").addDuration((Duration)e2.getValue());
        }
        return builder.addText("}").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurationForEnum that = (DurationForEnum)o;
        return this.type.equals(that.type) && this.defaultValue.equals(that.defaultValue) && this.valueForEnum.equals(that.valueForEnum);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.defaultValue, this.valueForEnum);
    }

    public static class Builder<E extends Enum<E>> {
        private final DurationForEnum<E> original;
        private Duration defaultValue;
        private EnumMap<E, Duration> valueForEnum = null;

        Builder(DurationForEnum<E> original) {
            this.original = original;
            this.defaultValue = original.defaultValue();
        }

        Class<E> type() {
            return this.original.type();
        }

        Duration defaultValue() {
            return this.defaultValue;
        }

        public Builder<E> withDefault(Duration defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder<E> withDefaultSec(int defaultValue) {
            return this.withDefault(Duration.ofSeconds(defaultValue));
        }

        public Builder<E> with(E key, Duration value) {
            if (this.valueForEnum == null) {
                this.valueForEnum = new EnumMap(this.original.type);
                for (Enum it : (Enum[])this.original.type.getEnumConstants()) {
                    if (!this.original.isSet(it)) continue;
                    this.valueForEnum.put(it, this.original.valueOf(it));
                }
            }
            this.valueForEnum.put(key, value);
            return this;
        }

        Map<E, Duration> copyValueForEnum() {
            if (this.valueForEnum == null) {
                return this.original.valueForEnum;
            }
            EnumMap copy = new EnumMap(this.original.type);
            for (Map.Entry<E, Duration> it : this.valueForEnum.entrySet()) {
                if (this.defaultValue.equals(it.getValue())) continue;
                copy.put((Enum)it.getKey(), it.getValue());
            }
            return copy;
        }

        public Builder<E> withValues(Map<E, Duration> values) {
            for (Map.Entry<E, Duration> e : values.entrySet()) {
                this.with((Enum)e.getKey(), e.getValue());
            }
            return this;
        }

        public Builder<E> apply(Consumer<Builder<E>> body) {
            body.accept(this);
            return this;
        }

        public DurationForEnum<E> build() {
            DurationForEnum it = new DurationForEnum(this);
            if (this.original != null && this.original.equals(it)) {
                return this.original;
            }
            return it;
        }
    }
}

