/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.framework;

import java.time.Duration;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.routing.api.request.framework.AbstractLinearFunction;
import org.opentripplanner.routing.api.request.framework.LinearFunctionSerialization;

public final class CostLinearFunction
extends AbstractLinearFunction<Cost> {
    public static CostLinearFunction ZERO = new CostLinearFunction(Cost.ZERO, 0.0);
    public static CostLinearFunction NORMAL = new CostLinearFunction(Cost.ZERO, 1.0);

    private CostLinearFunction(Cost a, double b) {
        super(a, b);
    }

    public static CostLinearFunction of(Cost constant, double coefficient) {
        if (constant.isZero() && coefficient == 0.0) {
            return ZERO;
        }
        return new CostLinearFunction(constant, coefficient);
    }

    public static CostLinearFunction of(Duration constant, double coefficient) {
        return CostLinearFunction.of(Cost.fromDuration(constant), coefficient);
    }

    public static CostLinearFunction of(String text) {
        return LinearFunctionSerialization.parse(text, (a, b) -> CostLinearFunction.of(Cost.fromDuration(a), (double)b)).orElseThrow();
    }

    public Cost calculate(Cost cost) {
        return ((Cost)this.constant()).plus(cost.multiply(this.coefficient()));
    }

    @Override
    protected boolean isZero(Cost value) {
        return value.isZero();
    }

    @Override
    protected Duration constantAsDuration() {
        return ((Cost)this.constant()).asDuration();
    }
}

