/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.framework;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import org.opentripplanner.framework.model.Units;
import org.opentripplanner.routing.api.request.framework.CostLinearFunction;
import org.opentripplanner.routing.api.request.framework.LinearFunctionSerialization;
import org.opentripplanner.routing.api.request.framework.TimePenalty;

abstract sealed class AbstractLinearFunction<T>
implements Serializable
permits CostLinearFunction, TimePenalty {
    private final T constant;
    private final double coefficient;

    protected AbstractLinearFunction(T constant, double coefficient) {
        this.constant = Objects.requireNonNull(constant);
        this.coefficient = Units.normalizedFactor(coefficient, 0.0, 100.0);
    }

    public final T constant() {
        return this.constant;
    }

    public final double coefficient() {
        return this.coefficient;
    }

    public final boolean isZero() {
        return this.isZero(this.constant) && this.coefficient == 0.0;
    }

    public final boolean isNormal() {
        return this.isZero(this.constant) && this.coefficient == 1.0;
    }

    public final String serialize() {
        return LinearFunctionSerialization.serialize(this);
    }

    public final String toString() {
        return this.serialize();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractLinearFunction that = (AbstractLinearFunction)o;
        return Objects.equals(that.coefficient, this.coefficient) && Objects.equals(this.constant, that.constant);
    }

    public int hashCode() {
        return Objects.hash(this.constant, this.coefficient);
    }

    protected abstract boolean isZero(T var1);

    protected abstract Duration constantAsDuration();
}

