/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request;

import java.util.EnumSet;
import java.util.Set;
import org.opentripplanner.framework.doc.DocumentedEnum;

public enum StreetMode implements DocumentedEnum<StreetMode>
{
    NOT_SET(Feature.ACCESS, Feature.TRANSFER, Feature.EGRESS),
    WALK(Feature.ACCESS, Feature.TRANSFER, Feature.EGRESS, Feature.WALKING),
    BIKE(Feature.ACCESS, Feature.TRANSFER, Feature.EGRESS, Feature.CYCLING),
    BIKE_TO_PARK(Feature.ACCESS, Feature.WALKING, Feature.CYCLING, Feature.PARKING),
    BIKE_RENTAL(Feature.ACCESS, Feature.EGRESS, Feature.WALKING, Feature.CYCLING, Feature.RENTING),
    SCOOTER_RENTAL(Feature.ACCESS, Feature.EGRESS, Feature.WALKING, Feature.SCOOTER, Feature.RENTING),
    CAR(Feature.ACCESS, Feature.TRANSFER, Feature.EGRESS, Feature.DRIVING),
    CAR_TO_PARK(Feature.ACCESS, Feature.WALKING, Feature.DRIVING, Feature.PARKING),
    CAR_PICKUP(Feature.ACCESS, Feature.EGRESS, Feature.WALKING, Feature.DRIVING, Feature.PICKUP),
    CAR_RENTAL(Feature.ACCESS, Feature.EGRESS, Feature.WALKING, Feature.DRIVING, Feature.RENTING),
    CAR_HAILING(Feature.ACCESS, Feature.EGRESS, Feature.DRIVING, Feature.PICKUP),
    FLEXIBLE(Feature.ACCESS, Feature.EGRESS, Feature.WALKING);

    private final Set<Feature> features;
    private static String GBFS_PREREQ;

    private StreetMode(Feature first, Feature ... rest) {
        this.features = EnumSet.of(first, rest);
    }

    public boolean accessAllowed() {
        return this.features.contains((Object)Feature.ACCESS);
    }

    public boolean transferAllowed() {
        return this.features.contains((Object)Feature.TRANSFER);
    }

    public boolean egressAllowed() {
        return this.features.contains((Object)Feature.EGRESS);
    }

    public boolean includesWalking() {
        return this.features.contains((Object)Feature.WALKING);
    }

    public boolean includesBiking() {
        return this.features.contains((Object)Feature.CYCLING);
    }

    public boolean includesDriving() {
        return this.features.contains((Object)Feature.DRIVING);
    }

    public boolean includesScooter() {
        return this.features.contains((Object)Feature.SCOOTER);
    }

    public boolean includesRenting() {
        return this.features.contains((Object)Feature.RENTING);
    }

    public boolean includesParking() {
        return this.features.contains((Object)Feature.PARKING);
    }

    public boolean includesPickup() {
        return this.features.contains((Object)Feature.PICKUP);
    }

    @Override
    public String typeDescription() {
        return "Routing modes on streets, including walking, biking, driving, and car-sharing.";
    }

    @Override
    public String enumValueDescription() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "";
            case 1 -> "Walking some or all of the way of the route.";
            case 2 -> "Cycling for the entirety of the route or taking a bicycle onto the public transport and cycling from the arrival station to the destination.\n\nTaking a bicycle onto transit is only possible if information about the permission to do so is supplied in the source data. In GTFS this field\nis called `bikesAllowed`.\n";
            case 3 -> "Leaving the bicycle at the departure station and walking from the arrival station to the destination.\nThis mode needs to be combined with at least one transit mode otherwise it behaves like an ordinary bicycle journey.\n\n_Prerequisite:_ Bicycle parking stations present in the OSM file and visible to OTP by enabling the property `staticBikeParkAndRide` during graph build.\n";
            case 4 -> "Taking a rented, shared-mobility bike for part or the entirety of the route.\n" + GBFS_PREREQ;
            case 5 -> "Walking to a scooter rental point, riding a scooter to a scooter rental drop-off point, and walking the rest of the way.\nThis can include scooter rental at fixed locations or free-floating services.\n" + GBFS_PREREQ;
            case 9 -> "Walk to a car rental point, drive to a car rental drop-off point and walk the rest of the way.\nThis can include car rental at fixed locations or free-floating services.\n" + GBFS_PREREQ;
            case 6 -> "Driving your own car the entirety of the route.\nThis can be combined with transit, where will return routes with a [Kiss & Ride](https://en.wikipedia.org/wiki/Park_and_ride#Kiss_and_ride_/_kiss_and_fly) component.\nThis means that the car is not parked in a permanent parking area but rather the passenger is dropped off (for example, at an airport) and the driver continues driving the car away from the drop off location.\n";
            case 7 -> "Driving a car to the park-and-ride facilities near a station and taking publictransport.\nThis mode needs to be combined with at least one transit mode otherwise, it behaves like an ordinary car journey.\n_Prerequisite:_ Park-and-ride areas near the stations need to be present in the OSM input file.\n";
            case 8 -> "Walking to a pickup point along the road, driving to a drop-off point along the road, and walking the rest of the way. <br/> This can include various taxi-services or kiss & ride.";
            case 10 -> "Using a car hailing app like Uber or Lyft to get to a train station or all the way to the destination.\n\nSee [the sandbox documentation](sandbox/RideHailing.md) on how to configure it.\n";
            case 11 -> "Encompasses all types of on-demand and flexible transportation for example GTFS Flex or NeTEx Flexible Stop Places.";
        };
    }

    static {
        GBFS_PREREQ = "\n_Prerequisite:_ Vehicle or station locations need to be added to OTP from dynamic data feeds.\nSee [Configuring GBFS](GBFS-Config.md) on how to add one.\n";
    }

    private static enum Feature {
        ACCESS,
        EGRESS,
        TRANSFER,
        WALKING,
        CYCLING,
        DRIVING,
        SCOOTER,
        RENTING,
        PARKING,
        PICKUP;

    }
}

