/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.model.plan.paging.cursor.PageCursor;
import org.opentripplanner.routing.api.request.RouteRequestBuilder;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.request.request.JourneyRequest;
import org.opentripplanner.routing.api.request.via.ViaLocation;
import org.opentripplanner.routing.api.response.InputField;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingErrorCode;
import org.opentripplanner.routing.error.RoutingValidationException;
import org.opentripplanner.utils.collection.ListSection;
import org.opentripplanner.utils.time.DurationUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteRequest
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(RouteRequest.class);
    private static final int DEFAULT_NUM_ITINERARIES = 50;
    private static final long NOW_THRESHOLD_SEC = DurationUtils.durationInSeconds((String)"15h");
    private static final RouteRequest DEFAULT = new RouteRequest();
    private final GenericLocation from;
    private final GenericLocation to;
    private final List<ViaLocation> via;
    private final Instant dateTime;
    private final boolean arriveBy;
    private final boolean timetableView;
    @Nullable
    private final Duration searchWindow;
    @Nullable
    private final Duration maxSearchWindow;
    @Nullable
    private final Instant bookingTime;
    @Nullable
    private final PageCursor pageCursor;
    private final JourneyRequest journey;
    private final RoutingPreferences preferences;
    private final int numItineraries;
    private final boolean defaultRequest;

    private RouteRequest() {
        this.from = null;
        this.to = null;
        this.via = Collections.emptyList();
        this.dateTime = null;
        this.arriveBy = false;
        this.timetableView = true;
        this.searchWindow = null;
        this.maxSearchWindow = null;
        this.bookingTime = null;
        this.pageCursor = null;
        this.journey = JourneyRequest.DEFAULT;
        this.preferences = RoutingPreferences.DEFAULT;
        this.numItineraries = 50;
        this.defaultRequest = true;
    }

    RouteRequest(RouteRequestBuilder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.via = builder.via;
        this.dateTime = !builder.defaultRequest && builder.dateTime == null ? RouteRequest.normalizeNow() : RouteRequest.normalizeDateTime(builder.dateTime);
        this.arriveBy = builder.arriveBy;
        this.timetableView = builder.timetableView;
        this.searchWindow = builder.searchWindow;
        this.maxSearchWindow = builder.maxSearchWindow;
        this.bookingTime = builder.bookingTime;
        this.pageCursor = builder.pageCursor;
        this.journey = builder.journey;
        this.preferences = builder.preferences;
        this.numItineraries = builder.numItineraries;
        this.defaultRequest = builder.defaultRequest;
        this.validate();
    }

    public static RouteRequestBuilder of() {
        return DEFAULT.copyOf();
    }

    public static RouteRequest defaultValue() {
        return DEFAULT;
    }

    @Nullable
    public static Instant normalizeDateTime(@Nullable Instant dateTime) {
        return dateTime == null ? null : dateTime.truncatedTo(ChronoUnit.SECONDS);
    }

    public static Instant normalizeNow() {
        return RouteRequest.normalizeDateTime(Instant.now());
    }

    public RouteRequestBuilder copyOf() {
        return new RouteRequestBuilder(this);
    }

    public JourneyRequest journey() {
        return this.journey;
    }

    public RoutingPreferences preferences() {
        return this.preferences;
    }

    public Instant bookingTime() {
        return this.bookingTime;
    }

    @Nullable
    public Instant dateTime() {
        return this.dateTime;
    }

    public static boolean isAPIGtfsTripPlannedForNow(Instant dateTime) {
        return Duration.between(dateTime, Instant.now()).abs().toSeconds() < NOW_THRESHOLD_SEC;
    }

    public SortOrder itinerariesSortOrder() {
        if (this.pageCursor != null) {
            return this.pageCursor.originalSortOrder();
        }
        return this.arriveBy ? SortOrder.STREET_AND_DEPARTURE_TIME : SortOrder.STREET_AND_ARRIVAL_TIME;
    }

    public RouteRequest withPageCursor() {
        if (this.pageCursor == null) {
            return this;
        }
        boolean arriveBy = this.arriveBy;
        if (this.pageCursor.latestArrivalTime() == null) {
            arriveBy = false;
        }
        RouteRequest request = this.copyOf().withArriveBy(arriveBy).withDateTime(arriveBy ? this.pageCursor.latestArrivalTime() : this.pageCursor.earliestDepartureTime()).withJourney(jb -> jb.withoutDirect()).buildRequest();
        LOG.debug("Request dateTime={} set from pageCursor.", (Object)request.dateTime());
        return request;
    }

    public ListSection cropItinerariesAt() {
        return this.pageCursor == null ? ListSection.TAIL : this.pageCursor.cropItinerariesAt();
    }

    public void validateOriginAndDestination() {
        ArrayList<RoutingError> routingErrors = new ArrayList<RoutingError>(2);
        if (this.from == null || !this.from.isSpecified()) {
            routingErrors.add(new RoutingError(RoutingErrorCode.LOCATION_NOT_FOUND, InputField.FROM_PLACE));
        }
        if (this.to == null || !this.to.isSpecified()) {
            routingErrors.add(new RoutingError(RoutingErrorCode.LOCATION_NOT_FOUND, InputField.TO_PLACE));
        }
        if (!routingErrors.isEmpty()) {
            throw new RoutingValidationException(routingErrors);
        }
    }

    @Nullable
    public GenericLocation from() {
        return this.from;
    }

    @Nullable
    public GenericLocation to() {
        return this.to;
    }

    public boolean allowTransferOptimization() {
        return !this.isViaSearch() || this.via.stream().allMatch(ViaLocation::isPassThroughLocation);
    }

    public boolean isViaSearch() {
        return !this.via.isEmpty();
    }

    public List<ViaLocation> getViaLocations() {
        return this.via;
    }

    public Duration searchWindow() {
        return this.searchWindow;
    }

    private boolean hasMaxSearchWindow() {
        return this.maxSearchWindow != null;
    }

    public Duration maxSearchWindow() {
        return this.maxSearchWindow;
    }

    public PageCursor pageCursor() {
        return this.pageCursor;
    }

    public boolean timetableView() {
        return this.timetableView;
    }

    public boolean arriveBy() {
        return this.arriveBy;
    }

    public int numItineraries() {
        return this.numItineraries;
    }

    boolean isDefaultRequest() {
        return this.defaultRequest;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteRequest other = (RouteRequest)o;
        return this.arriveBy == other.arriveBy && this.timetableView == other.timetableView && this.numItineraries == other.numItineraries && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Objects.equals(this.via, other.via) && Objects.equals(this.dateTime, other.dateTime) && Objects.equals(this.searchWindow, other.searchWindow) && Objects.equals(this.maxSearchWindow, other.maxSearchWindow) && Objects.equals(this.bookingTime, other.bookingTime) && Objects.equals(this.pageCursor, other.pageCursor) && Objects.equals(this.journey, other.journey) && Objects.equals(this.preferences, other.preferences);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.via, this.dateTime, this.arriveBy, this.timetableView, this.searchWindow, this.maxSearchWindow, this.bookingTime, this.pageCursor, this.journey, this.preferences, this.numItineraries);
    }

    public String toString() {
        return ToStringBuilder.of(RouteRequest.class).addObj("from", (Object)this.from).addObj("to", (Object)this.to).addCol("via", this.via).addDateTime("dateTime", this.dateTime).addBoolIfTrue("arriveBy", Boolean.valueOf(this.arriveBy)).addBoolIfTrue("timetableView: false", Boolean.valueOf(!this.timetableView)).addDuration("searchWindow", this.searchWindow).addDuration("maxSearchWindow", this.maxSearchWindow).addDateTime("bookingTime", this.bookingTime).addNum("numItineraries", (Number)this.numItineraries, (Number)50).addObj("preferences", (Object)this.preferences, (Object)RoutingPreferences.DEFAULT).addObj("journey", (Object)this.journey, (Object)JourneyRequest.DEFAULT).toString();
    }

    private void validate() {
        this.validateTimeNotSetIfDefaultRequest();
        ArrayList<RoutingError> routingErrors = new ArrayList<RoutingError>(2);
        routingErrors.addAll(this.validateFromAndToLocation());
        this.validateSearchWindow();
        if (!routingErrors.isEmpty()) {
            throw new RoutingValidationException(routingErrors);
        }
    }

    private void validateTimeNotSetIfDefaultRequest() {
        if (this.defaultRequest && this.dateTime != null) {
            throw new IllegalStateException();
        }
    }

    public List<RoutingError> validateFromAndToLocation() {
        if (this.defaultRequest) {
            if (this.from != null || this.to != null) {
                throw new IllegalStateException("from=" + String.valueOf(this.from) + ", to=" + String.valueOf(this.to));
            }
            return List.of();
        }
        ArrayList<RoutingError> routingErrors = new ArrayList<RoutingError>(2);
        if (this.from == null || !this.from.isSpecified()) {
            routingErrors.add(new RoutingError(RoutingErrorCode.LOCATION_NOT_FOUND, InputField.FROM_PLACE));
        }
        if (this.to == null || !this.to.isSpecified()) {
            routingErrors.add(new RoutingError(RoutingErrorCode.LOCATION_NOT_FOUND, InputField.TO_PLACE));
        }
        return routingErrors;
    }

    private void validateSearchWindow() {
        if (this.searchWindow != null) {
            if (this.hasMaxSearchWindow() && this.searchWindow.toSeconds() > this.maxSearchWindow.toSeconds()) {
                throw new IllegalArgumentException("The search window cannot exceed " + String.valueOf(this.maxSearchWindow));
            }
            if (this.searchWindow.isNegative()) {
                throw new IllegalArgumentException("The search window must be a positive duration");
            }
        }
    }
}

