/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request;

import java.util.Objects;
import org.opentripplanner.routing.api.request.RequestModesBuilder;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class RequestModes {
    private static final RequestModes DEFAULTS = new RequestModes(StreetMode.WALK, StreetMode.WALK, StreetMode.WALK, StreetMode.WALK);
    public final StreetMode accessMode;
    public final StreetMode egressMode;
    public final StreetMode directMode;
    public final StreetMode transferMode;

    private RequestModes(StreetMode accessMode, StreetMode egressMode, StreetMode directMode, StreetMode transferMode) {
        this.accessMode = accessMode != null && accessMode.accessAllowed() ? accessMode : StreetMode.NOT_SET;
        this.egressMode = egressMode != null && egressMode.egressAllowed() ? egressMode : StreetMode.NOT_SET;
        this.directMode = directMode != null ? directMode : StreetMode.NOT_SET;
        this.transferMode = transferMode != null && transferMode.transferAllowed() ? transferMode : StreetMode.NOT_SET;
    }

    public RequestModes(RequestModesBuilder builder) {
        this(builder.accessMode(), builder.egressMode(), builder.directMode(), builder.transferMode());
    }

    public static RequestModesBuilder of() {
        return DEFAULTS.copyOf();
    }

    public RequestModesBuilder copyOf() {
        return new RequestModesBuilder(this);
    }

    public static RequestModes defaultRequestModes() {
        return DEFAULTS;
    }

    public boolean contains(StreetMode streetMode) {
        return streetMode.equals(this.accessMode) || streetMode.equals(this.egressMode) || streetMode.equals(this.directMode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestModes that = (RequestModes)o;
        if (this.accessMode != that.accessMode) {
            return false;
        }
        if (this.egressMode != that.egressMode) {
            return false;
        }
        if (this.directMode != that.directMode) {
            return false;
        }
        return this.transferMode == that.transferMode;
    }

    public int hashCode() {
        return Objects.hash(this.accessMode, this.egressMode, this.directMode, this.transferMode);
    }

    public String toString() {
        return ToStringBuilder.of(RequestModes.class).addEnum("access", (Enum)this.accessMode).addEnum("egress", (Enum)this.egressMode).addEnum("direct", (Enum)this.directMode).addEnum("transfer", (Enum)this.transferMode).toString();
    }
}

