/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.routing.api.request.DebugEventType;
import org.opentripplanner.routing.api.request.DebugRaptor;
import org.opentripplanner.utils.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugRaptorBuilder
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DebugRaptorBuilder.class);
    private static final Pattern FIRST_STOP_PATTERN = Pattern.compile("(\\d+)\\*");
    private static final int FIRST_STOP_INDEX = 0;
    private static final int NOT_SET = -999999999;
    private List<Integer> stops;
    private List<Integer> path;
    private int debugPathFromStopIndex;
    private Set<DebugEventType> eventTypes;
    private final DebugRaptor original;

    public DebugRaptorBuilder(DebugRaptor original) {
        this.original = original;
        this.stops = null;
        this.path = null;
        this.debugPathFromStopIndex = -999999999;
        this.eventTypes = null;
    }

    public DebugRaptorBuilder withStops(String stops) {
        if (stops == null) {
            return this;
        }
        this.stops = DebugRaptorBuilder.split(stops);
        return this;
    }

    public DebugRaptorBuilder withPath(String path) {
        if (path == null) {
            return this;
        }
        this.path = DebugRaptorBuilder.split(path);
        this.debugPathFromStopIndex = DebugRaptorBuilder.firstStopIndexToDebug(this.path, path);
        return this;
    }

    public DebugRaptorBuilder withEventTypes(Collection<DebugEventType> eventTypes) {
        this.eventTypes = Set.copyOf(eventTypes);
        return this;
    }

    public DebugRaptorBuilder accept(Consumer<DebugRaptorBuilder> body) {
        body.accept(this);
        return this;
    }

    public DebugRaptor build() {
        DebugRaptor value = new DebugRaptor((List)ObjectUtils.ifNotNull(this.stops, this.original.stops()), (List)ObjectUtils.ifNotNull(this.path, this.original.path()), this.debugPathFromStopIndex == -999999999 ? this.original.debugPathFromStopIndex() : this.debugPathFromStopIndex, (Set)ObjectUtils.ifNotNull(this.eventTypes, this.original.eventTypes()));
        return this.original.equals(value) ? this.original : value;
    }

    private static List<Integer> split(String stops) {
        try {
            if (stops == null) {
                return List.of();
            }
            return Arrays.stream(stops.split("[\\s,;_*]+")).map(Integer::parseInt).toList();
        }
        catch (NumberFormatException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return List.of();
        }
    }

    private static int firstStopIndexToDebug(List<Integer> stops, String text) {
        if (text == null) {
            return 0;
        }
        Matcher m = FIRST_STOP_PATTERN.matcher(text);
        Integer stop = m.find() ? Integer.valueOf(Integer.parseInt(m.group(1))) : null;
        return stop == null ? 0 : stops.indexOf(stop);
    }

    private static String toString(List<Integer> stops, int fromStopIndex) {
        if (stops == null || stops.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < stops.size(); ++i) {
            buf.append(stops.get(i));
            if (i > 0 && i == fromStopIndex) {
                buf.append("*");
            }
            buf.append(", ");
        }
        return buf.substring(0, buf.length() - 2);
    }
}

