/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opentripplanner.routing.api.request.DebugEventType;
import org.opentripplanner.routing.api.request.DebugRaptorBuilder;
import org.opentripplanner.utils.collection.EnumSetUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class DebugRaptor
implements Serializable {
    private static final int FIRST_STOP_INDEX = 0;
    private static final int DEFAULT_DEBUG_PATH_FROM_STOP_INDEX = 0;
    private static final Set<DebugEventType> DEFAULT_EVENT_TYPES = Set.of(DebugEventType.STOP_ARRIVALS, DebugEventType.DESTINATION_ARRIVALS);
    private static final DebugRaptor DEFAULT = new DebugRaptor();
    private final List<Integer> stops;
    private final List<Integer> path;
    private final int debugPathFromStopIndex;
    private final Set<DebugEventType> eventTypes;

    DebugRaptor(List<Integer> stops, List<Integer> path, int debugPathFromStopIndex, Set<DebugEventType> eventTypes) {
        this.stops = List.copyOf(stops);
        this.path = List.copyOf(path);
        this.debugPathFromStopIndex = debugPathFromStopIndex;
        this.eventTypes = EnumSetUtils.unmodifiableEnumSet(eventTypes, DebugEventType.class);
    }

    public DebugRaptor() {
        this(List.of(), List.of(), 0, DEFAULT_EVENT_TYPES);
    }

    public static DebugRaptor defaltValue() {
        return DEFAULT;
    }

    public static DebugRaptorBuilder of() {
        return DEFAULT.copyOf();
    }

    public DebugRaptorBuilder copyOf() {
        return new DebugRaptorBuilder(this);
    }

    public boolean isEnabled() {
        return !this.stops.isEmpty() || !this.path.isEmpty();
    }

    public List<Integer> stops() {
        return this.stops;
    }

    public List<Integer> path() {
        return this.path;
    }

    public int debugPathFromStopIndex() {
        return this.debugPathFromStopIndex;
    }

    public Set<DebugEventType> eventTypes() {
        return this.eventTypes;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebugRaptor that = (DebugRaptor)o;
        return this.debugPathFromStopIndex == that.debugPathFromStopIndex && Objects.equals(this.stops, that.stops) && Objects.equals(this.path, that.path) && Objects.equals(this.eventTypes, that.eventTypes);
    }

    public int hashCode() {
        return Objects.hash(this.stops, this.path, this.debugPathFromStopIndex, this.eventTypes);
    }

    public String toString() {
        return ToStringBuilder.of(DebugRaptor.class).addObj("stops", (Object)DebugRaptor.stopsToString(this.stops, 0)).addObj("path", (Object)DebugRaptor.stopsToString(this.path, this.debugPathFromStopIndex)).addCol("eventType", this.eventTypes, DEFAULT_EVENT_TYPES).toString();
    }

    private static String stopsToString(List<Integer> stops, int fromStopIndex) {
        if (stops == null || stops.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < stops.size(); ++i) {
            buf.append(stops.get(i));
            if (i > 0 && i == fromStopIndex) {
                buf.append("*");
            }
            buf.append(", ");
        }
        return buf.substring(0, buf.length() - 2);
    }
}

