/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.alternativelegs;

import java.util.function.Function;
import java.util.function.Predicate;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.transit.model.network.TripPattern;

public enum AlternativeLegsFilter {
    NO_FILTER(leg -> tripPattern -> true),
    SAME_AGENCY(leg -> tripPattern -> leg.agency().equals(tripPattern.getRoute().getAgency())),
    SAME_ROUTE(leg -> tripPattern -> leg.route().equals(tripPattern.getRoute())),
    SAME_MODE(leg -> tripPattern -> leg.trip().getMode().equals(tripPattern.getMode())),
    SAME_SUBMODE(leg -> tripPattern -> leg.trip().getNetexSubMode().equals(tripPattern.getNetexSubmode()));

    public final Function<Leg, Predicate<TripPattern>> predicateGenerator;

    private AlternativeLegsFilter(Function<Leg, Predicate<TripPattern>> predicateGenerator) {
        this.predicateGenerator = predicateGenerator;
    }

    public Predicate<TripPattern> getFilter(Leg leg) {
        return this.predicateGenerator.apply(leg);
    }
}

