/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.services;

import java.util.HashSet;
import java.util.Set;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.routing.algorithm.transferoptimization.model.OptimizedPathTail;
import org.opentripplanner.routing.algorithm.transferoptimization.model.PathTailFilter;
import org.opentripplanner.utils.tostring.ToStringBuilder;

class TransitPathLegSelector<T extends RaptorTripSchedule> {
    private final PathTailFilter<T> filter;
    private Set<OptimizedPathTail<T>> remindingLegs;
    private Set<OptimizedPathTail<T>> selectedLegs;
    private int prevStopPosition = Integer.MAX_VALUE;

    TransitPathLegSelector(PathTailFilter<T> filter, Set<OptimizedPathTail<T>> legs) {
        this.filter = filter;
        this.remindingLegs = Set.copyOf(legs);
        this.selectedLegs = new HashSet<OptimizedPathTail<T>>();
    }

    Set<OptimizedPathTail<T>> next(int fromStopPosition) {
        if (fromStopPosition > this.prevStopPosition) {
            throw new IllegalStateException("The next method must be called with decreasing time limits. fromStopPosition=" + fromStopPosition + ", previousStopPosition=" + this.prevStopPosition);
        }
        this.prevStopPosition = fromStopPosition;
        HashSet candidates = new HashSet();
        HashSet<OptimizedPathTail<T>> rest = new HashSet<OptimizedPathTail<T>>();
        for (OptimizedPathTail<T> it : this.remindingLegs) {
            if (fromStopPosition < it.head().toStopPos()) {
                candidates.add(it);
                continue;
            }
            rest.add(it);
        }
        if (candidates.isEmpty()) {
            return this.selectedLegs;
        }
        candidates.addAll(this.selectedLegs);
        this.remindingLegs = rest;
        this.selectedLegs = this.filter.filterIntermediateResult(candidates, fromStopPosition);
        return this.selectedLegs;
    }

    public String toString() {
        return ToStringBuilder.of(TransitPathLegSelector.class).addObj("filter", this.filter).addCol("remindingLegs", this.remindingLegs).addCol("selectedLegs", this.selectedLegs).addNum("prevStopPosition", (Number)this.prevStopPosition).toString();
    }
}

