/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.model.passthrough;

import java.util.List;
import org.opentripplanner.raptor.api.model.RaptorTripPattern;
import org.opentripplanner.raptor.api.request.RaptorViaLocation;
import org.opentripplanner.raptor.path.PathBuilderLeg;
import org.opentripplanner.routing.algorithm.transferoptimization.model.OptimizedPathTail;
import org.opentripplanner.routing.algorithm.transferoptimization.model.passthrough.PassThroughPointsIterator;

class PathTailC2Calculator {
    private final List<RaptorViaLocation> viaLocations;

    PathTailC2Calculator(List<RaptorViaLocation> viaLocations) {
        this.viaLocations = viaLocations;
    }

    int calculateC2(OptimizedPathTail<?> tail) {
        return this.calculateAndSetC2ForLeg(tail.head()).currC2();
    }

    int calculateC2AtStopPos(OptimizedPathTail<?> tail, int fromStopPos) {
        return this.calculateC2ForLeg(tail.head(), fromStopPos);
    }

    private int calculateC2ForLeg(PathBuilderLeg<?> curr, int fromStopPos) {
        PassThroughPointsIterator ptpIter = this.calculateAndSetC2ForLeg(curr);
        this.calculateC2AtStopPos(curr, fromStopPos, ptpIter);
        return ptpIter.currC2();
    }

    private PassThroughPointsIterator calculateAndSetC2ForLeg(PathBuilderLeg<?> tail) {
        PassThroughPointsIterator ptpIter;
        PathBuilderLeg curr = this.findFirstLegWithC2Set(tail);
        if (curr.isEgress()) {
            ptpIter = PassThroughPointsIterator.tailIterator(this.viaLocations);
            curr.c2(ptpIter.currC2());
        } else {
            ptpIter = PassThroughPointsIterator.tailIterator(this.viaLocations, curr.c2());
        }
        while (curr != tail) {
            if (curr.isTransit()) {
                this.calculateC2AtStopPos(curr, curr.fromStopPos(), ptpIter);
            }
            curr = curr.prev();
            curr.c2(ptpIter.currC2());
        }
        curr.c2(ptpIter.currC2());
        return ptpIter;
    }

    private PathBuilderLeg<?> findFirstLegWithC2Set(PathBuilderLeg<?> tail) {
        while (!tail.isEgress()) {
            if (tail.isC2Set()) {
                return tail;
            }
            tail = tail.next();
        }
        return tail;
    }

    private void calculateC2AtStopPos(PathBuilderLeg<?> leg, int stopPos, PassThroughPointsIterator ptpIter) {
        RaptorTripPattern pattern = leg.trip().pattern();
        for (int pos = leg.toStopPos(); pos >= stopPos; --pos) {
            if (!ptpIter.isPassThroughPoint(pattern.stopIndex(pos))) continue;
            ptpIter.next();
        }
    }
}

