/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.model.passthrough;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.request.RaptorViaLocation;
import org.opentripplanner.routing.algorithm.transferoptimization.model.OptimizedPathTail;
import org.opentripplanner.routing.algorithm.transferoptimization.model.PathTailFilter;
import org.opentripplanner.routing.algorithm.transferoptimization.model.passthrough.PathTailC2Calculator;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class PassThroughPathTailFilter<T extends RaptorTripSchedule>
implements PathTailFilter<T> {
    private final PathTailFilter<T> filterChain;
    private final PathTailC2Calculator c2Calculator;

    public PassThroughPathTailFilter(PathTailFilter<T> filterChain, List<RaptorViaLocation> viaLocations) {
        this.filterChain = filterChain;
        this.c2Calculator = new PathTailC2Calculator(viaLocations);
    }

    @Override
    public Set<OptimizedPathTail<T>> filterIntermediateResult(Set<OptimizedPathTail<T>> elements, int boardStopPosition) {
        Map elementsByC2Value = elements.stream().collect(Collectors.groupingBy(it -> this.c2Calculator.calculateC2AtStopPos((OptimizedPathTail<?>)it, boardStopPosition), Collectors.toSet()));
        HashSet<OptimizedPathTail<T>> result = new HashSet<OptimizedPathTail<T>>();
        for (Set set : elementsByC2Value.values()) {
            result.addAll(this.filterChain.filterIntermediateResult(set, boardStopPosition));
        }
        return result;
    }

    @Override
    public Set<OptimizedPathTail<T>> filterFinalResult(Set<OptimizedPathTail<T>> elements) {
        Set result = elements.stream().peek(this.c2Calculator::calculateC2).filter(it -> it.head().c2() == 0).collect(Collectors.toSet());
        return this.filterChain.filterFinalResult(result);
    }

    public String toString() {
        return ToStringBuilder.of(PassThroughPathTailFilter.class).addObj("c2Calculator", (Object)this.c2Calculator).addObj("filterChain", this.filterChain).toString();
    }
}

