/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.model.costfilter;

import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.routing.algorithm.transferoptimization.model.OptimizedPathTail;
import org.opentripplanner.routing.algorithm.transferoptimization.model.PathTailFilter;
import org.opentripplanner.routing.algorithm.transferoptimization.model.costfilter.MinCostPathTailFilter;

public class MinCostPathTailFilterFactory<T extends RaptorTripSchedule> {
    private final boolean transferPriority;
    private final boolean optimizeWaitTime;

    public MinCostPathTailFilterFactory(boolean transferPriority, boolean optimizeWaitTime) {
        this.transferPriority = transferPriority;
        this.optimizeWaitTime = optimizeWaitTime;
    }

    public PathTailFilter<T> createFilter() {
        ArrayList filters = new ArrayList(3);
        if (this.transferPriority) {
            filters.add(OptimizedPathTail::transferPriorityCost);
        }
        if (this.optimizeWaitTime) {
            filters.add(OptimizedPathTail::generalizedCostWaitTimeOptimized);
        } else {
            filters.add(OptimizedPathTail::generalizedCost);
        }
        filters.add(OptimizedPathTail::breakTieCost);
        return new MinCostPathTailFilter(filters);
    }

    public static <T extends RaptorTripSchedule> PathTailFilter<T> ofCostFunction(ToIntFunction<OptimizedPathTail<T>> costFunction) {
        return new MinCostPathTailFilter<T>(List.of(costFunction));
    }
}

