/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.model.costfilter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.routing.algorithm.transferoptimization.model.OptimizedPathTail;
import org.opentripplanner.routing.algorithm.transferoptimization.model.PathTailFilter;
import org.opentripplanner.utils.tostring.ToStringBuilder;

class MinCostPathTailFilter<T extends RaptorTripSchedule>
implements PathTailFilter<T> {
    private final List<ToIntFunction<OptimizedPathTail<T>>> costFunctions;

    MinCostPathTailFilter(List<ToIntFunction<OptimizedPathTail<T>>> costFunctions) {
        this.costFunctions = costFunctions;
    }

    @Override
    public Set<OptimizedPathTail<T>> filterIntermediateResult(Set<OptimizedPathTail<T>> elements, int boardStopPosition) {
        for (ToIntFunction<OptimizedPathTail<T>> costFunction : this.costFunctions) {
            elements = this.filter(elements, costFunction);
        }
        return elements;
    }

    @Override
    public Set<OptimizedPathTail<T>> filterFinalResult(Set<OptimizedPathTail<T>> elements) {
        return this.filterIntermediateResult(elements, 0);
    }

    private Set<OptimizedPathTail<T>> filter(Set<OptimizedPathTail<T>> elements, ToIntFunction<OptimizedPathTail<T>> costFunction) {
        HashSet<OptimizedPathTail<T>> result = new HashSet<OptimizedPathTail<T>>();
        int minCost = Integer.MAX_VALUE;
        for (OptimizedPathTail<T> it : elements) {
            int cost = costFunction.applyAsInt(it);
            if (cost == minCost) {
                result.add(it);
                continue;
            }
            if (cost >= minCost) continue;
            minCost = cost;
            result.clear();
            result.add(it);
        }
        return result;
    }

    public String toString() {
        return ToStringBuilder.of(MinCostPathTailFilter.class).addCol("costFunctions", this.costFunctions).toString();
    }
}

