/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.model;

import org.opentripplanner.raptor.api.model.RaptorCostConverter;

public class TransferWaitTimeCostCalculator {
    public static final int ZERO_COST = 0;
    private static final int STAY_SEATED_COST = -100000;
    private static final int GUARANTEED_COST = -50000;
    private final double n;
    private final double backTravelWaitTimeFactor;
    private int t0 = -1;
    private double a = Double.NaN;

    public TransferWaitTimeCostCalculator(double backTravelWaitTimeFactor, double minSafeWaitTimeFactor) {
        this.backTravelWaitTimeFactor = backTravelWaitTimeFactor;
        this.n = minSafeWaitTimeFactor;
    }

    public void setMinSafeTransferTime(int minSafeTransferTime) {
        this.t0 = minSafeTransferTime;
        this.a = 1.718281828459045 / (double)minSafeTransferTime;
    }

    double avoidShortWaitTimeCost(int waitTime) {
        return this.n * (double)this.t0 / (1.0 + (this.n - 1.0) * Math.log1p(this.a * (double)waitTime));
    }

    double avoidBackTravelCost(int waitTime) {
        return -((double)waitTime * this.backTravelWaitTimeFactor);
    }

    int calculateStaySeatedTransferCost() {
        return RaptorCostConverter.toRaptorCost((int)-100000);
    }

    int calculateGuaranteedTransferCost() {
        return RaptorCostConverter.toRaptorCost((int)-50000);
    }

    int calculateOptimizedWaitCost(int waitTime) {
        if (waitTime < 0) {
            return 0;
        }
        this.assertMinSafeTransferTimeSet();
        return RaptorCostConverter.toRaptorCost((double)(this.avoidShortWaitTimeCost(waitTime) + this.avoidBackTravelCost(waitTime)));
    }

    private void assertMinSafeTransferTimeSet() {
        if (this.t0 < 0) {
            throw new IllegalStateException("Min safe transfer time is not set!");
        }
    }
}

