/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.configure;

import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.raptor.api.model.RaptorStopNameResolver;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.request.RaptorViaLocation;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.raptor.spi.RaptorTransitDataProvider;
import org.opentripplanner.routing.algorithm.transferoptimization.OptimizeTransferService;
import org.opentripplanner.routing.algorithm.transferoptimization.api.TransferOptimizationParameters;
import org.opentripplanner.routing.algorithm.transferoptimization.model.MinSafeTransferTimeCalculator;
import org.opentripplanner.routing.algorithm.transferoptimization.model.PathTailFilter;
import org.opentripplanner.routing.algorithm.transferoptimization.model.TransferWaitTimeCostCalculator;
import org.opentripplanner.routing.algorithm.transferoptimization.model.costfilter.MinCostPathTailFilterFactory;
import org.opentripplanner.routing.algorithm.transferoptimization.model.passthrough.PassThroughPathTailFilter;
import org.opentripplanner.routing.algorithm.transferoptimization.services.OptimizePathDomainService;
import org.opentripplanner.routing.algorithm.transferoptimization.services.TransferGenerator;
import org.opentripplanner.routing.algorithm.transferoptimization.services.TransferServiceAdaptor;
import org.opentripplanner.transit.model.site.StopLocation;

public class TransferOptimizationServiceConfigurator<T extends RaptorTripSchedule> {
    private final IntFunction<StopLocation> stopLookup;
    private final RaptorStopNameResolver stopNameResolver;
    private final TransferService transferService;
    private final RaptorTransitDataProvider<T> transitDataProvider;
    @Nullable
    private final int[] stopBoardAlightTransferCosts;
    private final TransferOptimizationParameters config;
    private final List<RaptorViaLocation> viaLocations;

    private TransferOptimizationServiceConfigurator(IntFunction<StopLocation> stopLookup, RaptorStopNameResolver stopNameResolver, TransferService transferService, RaptorTransitDataProvider<T> transitDataProvider, int[] stopBoardAlightTransferCosts, TransferOptimizationParameters config, List<RaptorViaLocation> viaLocations) {
        this.stopLookup = stopLookup;
        this.stopNameResolver = stopNameResolver;
        this.transferService = transferService;
        this.transitDataProvider = transitDataProvider;
        this.stopBoardAlightTransferCosts = stopBoardAlightTransferCosts;
        this.config = config;
        this.viaLocations = viaLocations;
    }

    public static <T extends RaptorTripSchedule> OptimizeTransferService<T> createOptimizeTransferService(IntFunction<StopLocation> stopLookup, RaptorStopNameResolver stopNameResolver, TransferService transferService, RaptorTransitDataProvider<T> transitDataProvider, @Nullable int[] stopBoardAlightTransferCosts, TransferOptimizationParameters config, List<RaptorViaLocation> viaLocations) {
        return new TransferOptimizationServiceConfigurator<T>(stopLookup, stopNameResolver, transferService, transitDataProvider, stopBoardAlightTransferCosts, config, viaLocations).createOptimizeTransferService();
    }

    private OptimizeTransferService<T> createOptimizeTransferService() {
        TransferGenerator<T> pathTransferGenerator = this.createTransferGenerator(this.config.optimizeTransferPriority());
        if (this.config.optimizeTransferWaitTime()) {
            TransferWaitTimeCostCalculator transferWaitTimeCalculator = this.createTransferWaitTimeCalculator();
            OptimizePathDomainService<T> transfersPermutationService = this.createOptimizePathService(pathTransferGenerator, transferWaitTimeCalculator, this.transitDataProvider.multiCriteriaCostCalculator());
            return new OptimizeTransferService<T>(transfersPermutationService, this.createMinSafeTxTimeService(), transferWaitTimeCalculator);
        }
        OptimizePathDomainService<T> transfersPermutationService = this.createOptimizePathService(pathTransferGenerator, null, this.transitDataProvider.multiCriteriaCostCalculator());
        return new OptimizeTransferService<T>(transfersPermutationService);
    }

    private OptimizePathDomainService<T> createOptimizePathService(TransferGenerator<T> transferGenerator, TransferWaitTimeCostCalculator transferWaitTimeCostCalculator, RaptorCostCalculator<T> costCalculator) {
        return new OptimizePathDomainService<T>(transferGenerator, costCalculator, this.transitDataProvider.slackProvider(), transferWaitTimeCostCalculator, this.stopBoardAlightTransferCosts, this.config.extraStopBoardAlightCostsFactor(), this.createFilter(), this.stopNameResolver);
    }

    private MinSafeTransferTimeCalculator<T> createMinSafeTxTimeService() {
        return new MinSafeTransferTimeCalculator(this.transitDataProvider.slackProvider());
    }

    private TransferGenerator<T> createTransferGenerator(boolean transferPriority) {
        TransferServiceAdaptor transferServiceAdaptor = this.transferService != null && transferPriority ? TransferServiceAdaptor.create(this.stopLookup, this.transferService) : TransferServiceAdaptor.noop();
        return new TransferGenerator(transferServiceAdaptor, this.transitDataProvider);
    }

    private TransferWaitTimeCostCalculator createTransferWaitTimeCalculator() {
        return new TransferWaitTimeCostCalculator(this.config.backTravelWaitTimeFactor(), this.config.minSafeWaitTimeFactor());
    }

    private PathTailFilter<T> createFilter() {
        PathTailFilter filter = new MinCostPathTailFilterFactory(this.config.optimizeTransferPriority(), this.config.optimizeTransferWaitTime()).createFilter();
        if (!this.viaLocations.isEmpty()) {
            filter = new PassThroughPathTailFilter(filter, this.viaLocations);
        }
        return filter;
    }
}

