/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.util.List;

final class TripTimesForDaysIndex {
    private final int[] tripIndex;

    static TripTimesForDaysIndex ofTripTimesForDay(List<int[]> departureTimes, int[] offsets) {
        departureTimes = TripTimesForDaysIndex.applyOffsets(departureTimes, offsets);
        return new TripTimesForDaysIndex(departureTimes);
    }

    TripTimesForDaysIndex(List<int[]> firstStopDepartureTimesPerDay) {
        List<int[]> list = firstStopDepartureTimesPerDay;
        this.tripIndex = new int[list.stream().mapToInt(a -> ((int[])a).length).sum() * 2];
        int day = 0;
        int[] a2 = list.get(day);
        int tripIndexIndex = 0;
        int i = 0;
        int j = 0;
        int u = TripTimesForDaysIndex.safeValueAt(a2, i);
        int v = TripTimesForDaysIndex.safeValueNextDayAt(list, day, j);
        while (true) {
            if (u <= v) {
                if (i < a2.length) {
                    tripIndexIndex = this.setIndexValue(tripIndexIndex, day, i);
                }
                if (++i < a2.length) {
                    u = a2[i];
                    continue;
                }
                if (++day == list.size()) break;
                i = j;
                a2 = list.get(day);
                if (i == a2.length) {
                    if (++day == list.size()) break;
                    i = 0;
                    a2 = list.get(day);
                }
                j = 0;
                u = TripTimesForDaysIndex.safeValueAt(a2, i);
                v = TripTimesForDaysIndex.safeValueNextDayAt(list, day, j);
                continue;
            }
            tripIndexIndex = this.setIndexValue(tripIndexIndex, day + 1, j);
            v = TripTimesForDaysIndex.safeValueNextDayAt(list, day, ++j);
        }
    }

    private static int safeValueNextDayAt(List<int[]> list, int day, int trip) {
        int nextDay = day + 1;
        return nextDay == list.size() ? Integer.MAX_VALUE : TripTimesForDaysIndex.safeValueAt(list.get(nextDay), trip);
    }

    private static int safeValueAt(int[] array, int index) {
        return array.length == index ? Integer.MAX_VALUE : array[index];
    }

    int day(int tripIndexForDays) {
        return this.tripIndex[tripIndexForDays * 2];
    }

    int tripIndexForDay(int tripIndexForDays) {
        return this.tripIndex[tripIndexForDays * 2 + 1];
    }

    int size() {
        return this.tripIndex.length / 2;
    }

    private int setIndexValue(int tripIndexIndex, int day, int tripIndexForDay) {
        this.tripIndex[tripIndexIndex * 2] = day;
        this.tripIndex[tripIndexIndex * 2 + 1] = tripIndexForDay;
        return tripIndexIndex + 1;
    }

    static List<int[]> applyOffsets(List<int[]> list, int[] offsets) {
        for (int i = 0; i < list.size(); ++i) {
            int o = offsets[i];
            int[] a = list.get(i);
            for (int j = 0; j < a.length; ++j) {
                a[j] = a[j] + o;
            }
        }
        return list;
    }

    public String toString() {
        if (this.tripIndex.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.tripIndex.length; i += 2) {
            buf.append(this.tripIndex[i]).append(':').append(this.tripIndex[i + 1]).append(' ');
        }
        return buf.substring(0, buf.length() - 1);
    }
}

