/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.util.function.IntUnaryOperator;
import org.opentripplanner.raptor.api.model.RaptorTransferConstraint;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.spi.RaptorBoardOrAlightEvent;
import org.opentripplanner.raptor.spi.RaptorTripScheduleSearch;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripSearchTimetable;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class TripScheduleBoardSearch<T extends RaptorTripSchedule>
implements RaptorTripScheduleSearch<T>,
RaptorBoardOrAlightEvent<T> {
    private final TripSearchTimetable<T> timetable;
    private final int nTrips;
    private final int binarySearchThreshold;
    private int earliestBoardTime;
    private int stopPositionInPattern;
    private IntUnaryOperator departureTimes;
    private T candidateTrip;
    private int candidateTripIndex = -2111000000;

    TripScheduleBoardSearch(TripSearchTimetable<T> timetable, int binarySearchThreshold) {
        this.timetable = timetable;
        this.nTrips = timetable.numberOfTripSchedules();
        this.binarySearchThreshold = binarySearchThreshold;
    }

    public T trip() {
        return this.candidateTrip;
    }

    public int tripIndex() {
        return this.candidateTripIndex;
    }

    public int time() {
        return this.candidateTrip.departure(this.stopPositionInPattern);
    }

    public int earliestBoardTime() {
        return this.earliestBoardTime;
    }

    public int stopPositionInPattern() {
        return this.stopPositionInPattern;
    }

    public RaptorTransferConstraint transferConstraint() {
        return RaptorTransferConstraint.REGULAR_TRANSFER;
    }

    public boolean empty() {
        return this.candidateTripIndex == -2111000000;
    }

    public RaptorBoardOrAlightEvent<T> search(int earliestTime, int stopPositionInPattern, int tripIndexUpperBound) {
        this.earliestBoardTime = earliestTime;
        this.stopPositionInPattern = stopPositionInPattern;
        this.departureTimes = this.timetable.getDepartureTimes(stopPositionInPattern);
        this.candidateTrip = null;
        this.candidateTripIndex = -2111000000;
        if (tripIndexUpperBound == -1) {
            if (this.nTrips > this.binarySearchThreshold) {
                return this.findFirstBoardingOptimizedForLargeSetOfTrips();
            }
            return this.findBoardingBySteppingBackwardsInTime(this.nTrips);
        }
        return this.findBoardingBySteppingBackwardsInTime(tripIndexUpperBound);
    }

    public String toString() {
        return ToStringBuilder.of(TripScheduleBoardSearch.class).addObj("nTrips", (Object)this.nTrips).addObj("earliestBoardTime", (Object)this.earliestBoardTime).addObj("stopPos", (Object)this.stopPositionInPattern).addObj("tripIndex", (Object)this.candidateTripIndex).addObj("trip", this.candidateTrip).toString();
    }

    private RaptorBoardOrAlightEvent<T> findFirstBoardingOptimizedForLargeSetOfTrips() {
        int indexBestGuess = this.binarySearchForTripIndex();
        RaptorBoardOrAlightEvent<T> result = this.findBoardingBySteppingBackwardsInTime(indexBestGuess);
        if (!result.empty()) {
            return this;
        }
        return this.findBoardingBySteppingForwardInTime(indexBestGuess);
    }

    private RaptorBoardOrAlightEvent<T> findBoardingBySteppingBackwardsInTime(int tripIndexUpperBound) {
        int i = tripIndexUpperBound - 1;
        while (i >= 0 && this.departureTimes.applyAsInt(i) >= this.earliestBoardTime) {
            this.candidateTripIndex = i--;
        }
        if (this.candidateTripIndex != -2111000000) {
            this.candidateTrip = this.timetable.getTripSchedule(this.candidateTripIndex);
        }
        return this;
    }

    private RaptorBoardOrAlightEvent<T> findBoardingBySteppingForwardInTime(int tripIndexLowerBound) {
        for (int i = tripIndexLowerBound; i < this.nTrips; ++i) {
            if (this.departureTimes.applyAsInt(i) < this.earliestBoardTime) continue;
            this.candidateTrip = this.timetable.getTripSchedule(i);
            this.candidateTripIndex = i;
            return this;
        }
        return this;
    }

    private int binarySearchForTripIndex() {
        int lower = 0;
        int upper = this.nTrips;
        while (upper - lower > this.binarySearchThreshold) {
            int m = (lower + upper) / 2;
            if (this.departureTimes.applyAsInt(m) >= this.earliestBoardTime) {
                upper = m;
                continue;
            }
            lower = m;
        }
        return upper == this.nTrips ? this.nTrips : upper + 1;
    }
}

