/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.function.IntUnaryOperator;
import org.opentripplanner.raptor.api.model.RaptorTripPattern;
import org.opentripplanner.raptor.api.model.SearchDirection;
import org.opentripplanner.raptor.spi.IntIterator;
import org.opentripplanner.raptor.spi.RaptorRoute;
import org.opentripplanner.raptor.spi.RaptorTimeTable;
import org.opentripplanner.raptor.spi.RaptorTripScheduleSearch;
import org.opentripplanner.raptor.util.IntIterators;
import org.opentripplanner.routing.algorithm.raptoradapter.api.DefaultTripPattern;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.frequency.TripFrequencyAlightSearch;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.frequency.TripFrequencyBoardSearch;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripScheduleSearchFactory;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripScheduleWithOffset;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripSearchTimetable;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripTimesForDaysIndex;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.RoutingTripPattern;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class TripPatternForDates
implements RaptorRoute<TripSchedule>,
RaptorTimeTable<TripSchedule>,
DefaultTripPattern,
TripSearchTimetable<TripSchedule> {
    private static final int FIRST_STOP_POS_IN_PATTERN = 0;
    private final RoutingTripPattern tripPattern;
    private final TripPatternForDate[] tripPatternForDates;
    private final int[] offsets;
    private final int numberOfTripSchedules;
    private final boolean isFrequencyBased;
    private final int[] arrivalTimes;
    private final int[] departureTimes;
    private final Accessibility[] wheelchairBoardings;
    private final BitSet boardingPossible;
    private final BitSet alightingPossible;
    private final int priorityGroupId;

    TripPatternForDates(RoutingTripPattern tripPattern, TripPatternForDate[] tripPatternForDates, int[] offsets, BitSet boardingPossible, BitSet alightningPossible, int priorityGroupId) {
        this.tripPattern = tripPattern;
        this.tripPatternForDates = tripPatternForDates;
        this.offsets = offsets;
        this.boardingPossible = boardingPossible;
        this.alightingPossible = alightningPossible;
        this.priorityGroupId = priorityGroupId;
        int numberOfTripSchedules = 0;
        boolean hasFrequencies = false;
        for (TripPatternForDate tripPatternForDate : this.tripPatternForDates) {
            numberOfTripSchedules += tripPatternForDate.numberOfTripSchedules();
            if (!tripPatternForDate.hasFrequencies()) continue;
            hasFrequencies = true;
        }
        this.numberOfTripSchedules = numberOfTripSchedules;
        this.isFrequencyBased = hasFrequencies;
        this.wheelchairBoardings = new Accessibility[numberOfTripSchedules];
        int nStops = tripPattern.numberOfStopsInPattern();
        this.arrivalTimes = new int[nStops * numberOfTripSchedules];
        this.departureTimes = new int[nStops * numberOfTripSchedules];
        TripTimesForDaysIndex tripIndex = TripPatternForDates.createTripTimesForDaysIndex(tripPatternForDates, offsets);
        for (int i = 0; i < tripIndex.size(); ++i) {
            int day = tripIndex.day(i);
            int offset = this.offsets[day];
            TripTimes tt = tripPatternForDates[day].tripTimes().get(tripIndex.tripIndexForDay(i));
            this.wheelchairBoardings[i] = tt.getWheelchairAccessibility();
            for (int s = 0; s < nStops; ++s) {
                this.arrivalTimes[s * numberOfTripSchedules + i] = tt.getArrivalTime(s) + offset;
                this.departureTimes[s * numberOfTripSchedules + i] = tt.getDepartureTime(s) + offset;
            }
        }
    }

    public RoutingTripPattern getTripPattern() {
        return this.tripPattern;
    }

    public IntIterator tripPatternForDatesIndexIterator(boolean ascendingOnDate) {
        return ascendingOnDate ? IntIterators.intIncIterator((int)0, (int)this.tripPatternForDates.length) : IntIterators.intDecIterator((int)this.tripPatternForDates.length, (int)0);
    }

    public TripPatternForDate tripPatternForDate(int dayIndex) {
        return this.tripPatternForDates[dayIndex];
    }

    @Deprecated
    public int tripPatternForDateOffsets(int dayIndex) {
        return this.offsets[dayIndex];
    }

    public RaptorTimeTable<TripSchedule> timetable() {
        return this;
    }

    public RaptorTripPattern pattern() {
        return this;
    }

    public int patternIndex() {
        return this.tripPattern.patternIndex();
    }

    public int numberOfStopsInPattern() {
        return this.tripPattern.numberOfStopsInPattern();
    }

    public int stopIndex(int stopPositionInPattern) {
        return this.tripPattern.stopIndex(stopPositionInPattern);
    }

    public boolean boardingPossibleAt(int stopPositionInPattern) {
        return this.boardingPossible.get(stopPositionInPattern);
    }

    public boolean alightingPossibleAt(int stopPositionInPattern) {
        return this.alightingPossible.get(stopPositionInPattern);
    }

    public int slackIndex() {
        return this.tripPattern.slackIndex();
    }

    public int priorityGroupId() {
        return this.priorityGroupId;
    }

    public int transitReluctanceFactorIndex() {
        return this.tripPattern.transitReluctanceFactorIndex();
    }

    public String debugInfo() {
        return this.tripPattern.debugInfo();
    }

    public RaptorTripScheduleSearch<TripSchedule> tripSearch(SearchDirection direction) {
        if (this.useCustomizedTripSearch()) {
            return this.createCustomizedTripSearch(direction);
        }
        return TripScheduleSearchFactory.create(direction, this);
    }

    public TripSchedule getTripSchedule(int tripIndex) {
        return new TripScheduleWithOffset(this, tripIndex);
    }

    @Override
    public IntUnaryOperator getArrivalTimes(int stopPositionInPattern) {
        int base = stopPositionInPattern * this.numberOfTripSchedules;
        return tripIndex -> this.arrivalTimes[base + tripIndex];
    }

    @Override
    public IntUnaryOperator getDepartureTimes(int stopPositionInPattern) {
        int base = stopPositionInPattern * this.numberOfTripSchedules;
        return tripIndex -> this.departureTimes[base + tripIndex];
    }

    public IntUnaryOperator getArrivalTimesForTrip(int tripIndex) {
        return stopPositionInPattern -> this.arrivalTimes[stopPositionInPattern * this.numberOfTripSchedules + tripIndex];
    }

    public IntUnaryOperator getDepartureTimesForTrip(int tripIndex) {
        return stopPositionInPattern -> this.departureTimes[stopPositionInPattern * this.numberOfTripSchedules + tripIndex];
    }

    public int numberOfTripSchedules() {
        return this.numberOfTripSchedules;
    }

    @Override
    public Route route() {
        return this.tripPattern.route();
    }

    public boolean useCustomizedTripSearch() {
        return this.isFrequencyBased;
    }

    public RaptorTripScheduleSearch<TripSchedule> createCustomizedTripSearch(SearchDirection direction) {
        return direction.isForward() ? new TripFrequencyBoardSearch(this) : new TripFrequencyAlightSearch(this);
    }

    public String toString() {
        return ToStringBuilder.of(TripPatternForDates.class).addObj("pattern", (Object)this.debugInfo()).addServiceTimeSchedule("offsets", this.offsets).addNum("nTrips", (Number)this.numberOfTripSchedules).toString();
    }

    public Accessibility wheelchairBoardingForTrip(int tripIndex) {
        return this.wheelchairBoardings[tripIndex];
    }

    private static TripTimesForDaysIndex createTripTimesForDaysIndex(TripPatternForDate[] tripPatternForDates, int[] offsets) {
        List<int[]> departureTimes = Arrays.stream(tripPatternForDates).map(TripPatternForDate::tripTimes).map(l -> l.stream().mapToInt(t -> t.getDepartureTime(0)).toArray()).toList();
        return TripTimesForDaysIndex.ofTripTimesForDay(departureTimes, offsets);
    }
}

