/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.util.BitSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.BoardAlight;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TransitDataProviderFilter;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.WheelchairPreferences;
import org.opentripplanner.routing.api.request.request.filter.TransitFilter;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.BikeAccess;
import org.opentripplanner.transit.model.network.CarAccess;
import org.opentripplanner.transit.model.network.RoutingTripPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;

public class RouteRequestTransitDataProviderFilter
implements TransitDataProviderFilter {
    private final boolean requireBikesAllowed;
    private final boolean requireCarsAllowed;
    private final boolean wheelchairEnabled;
    private final WheelchairPreferences wheelchairPreferences;
    private final boolean includePlannedCancellations;
    private final boolean includeRealtimeCancellations;
    private final TransitFilter[] filters;
    private final Set<FeedScopedId> bannedTrips;
    private final boolean hasSubModeFilters;

    public RouteRequestTransitDataProviderFilter(RouteRequest request) {
        this(request.journey().transfer().mode() == StreetMode.BIKE, request.journey().transfer().mode() == StreetMode.CAR, request.journey().wheelchair(), request.preferences().wheelchair(), request.preferences().transit().includePlannedCancellations(), request.preferences().transit().includeRealtimeCancellations(), Set.copyOf(request.journey().transit().bannedTrips()), request.journey().transit().filters());
    }

    public RouteRequestTransitDataProviderFilter(boolean requireBikesAllowed, boolean requireCarsAllowed, boolean wheelchairEnabled, WheelchairPreferences wheelchairPreferences, boolean includePlannedCancellations, boolean includeRealtimeCancellations, Set<FeedScopedId> bannedTrips, List<TransitFilter> filters) {
        this.requireBikesAllowed = requireBikesAllowed;
        this.requireCarsAllowed = requireCarsAllowed;
        this.wheelchairEnabled = wheelchairEnabled;
        this.wheelchairPreferences = wheelchairPreferences;
        this.includePlannedCancellations = includePlannedCancellations;
        this.includeRealtimeCancellations = includeRealtimeCancellations;
        this.bannedTrips = bannedTrips;
        this.filters = (TransitFilter[])filters.toArray(TransitFilter[]::new);
        this.hasSubModeFilters = filters.stream().anyMatch(TransitFilter::isSubModePredicate);
    }

    @Override
    public boolean hasSubModeFilters() {
        return this.hasSubModeFilters;
    }

    public static BikeAccess bikeAccessForTrip(Trip trip) {
        if (trip.getBikesAllowed() != BikeAccess.UNKNOWN) {
            return trip.getBikesAllowed();
        }
        return trip.getRoute().getBikesAllowed();
    }

    @Override
    public boolean tripPatternPredicate(TripPatternForDate tripPatternForDate) {
        for (TransitFilter filter : this.filters) {
            if (!filter.matchTripPattern(tripPatternForDate.getTripPattern().getPattern())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean tripTimesPredicate(TripTimes tripTimes, boolean withFilters) {
        Trip trip = tripTimes.getTrip();
        if (this.requireBikesAllowed && RouteRequestTransitDataProviderFilter.bikeAccessForTrip(trip) != BikeAccess.ALLOWED) {
            return false;
        }
        if (this.requireCarsAllowed && trip.getCarsAllowed() != CarAccess.ALLOWED) {
            return false;
        }
        if (this.wheelchairEnabled && this.wheelchairPreferences.trip().onlyConsiderAccessible() && tripTimes.getWheelchairAccessibility() != Accessibility.POSSIBLE) {
            return false;
        }
        if (!this.includePlannedCancellations && trip.getNetexAlteration().isCanceledOrReplaced()) {
            return false;
        }
        if (!this.includeRealtimeCancellations && tripTimes.isCanceled()) {
            return false;
        }
        if (this.bannedTrips.contains(trip.getId())) {
            return false;
        }
        if (withFilters) {
            for (TransitFilter f : this.filters) {
                if (!f.matchTripTimes(tripTimes)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public BitSet filterAvailableStops(RoutingTripPattern tripPattern, BitSet boardingPossible, BoardAlight boardAlight) {
        BitSet result = boardingPossible;
        if (this.includeRealtimeCancellations) {
            TripPattern pattern = tripPattern.getPattern();
            int nStops = pattern.numberOfStops();
            result = new BitSet(nStops);
            for (int i = 0; i < nStops; ++i) {
                PickDrop pickDrop = switch (boardAlight) {
                    default -> throw new MatchException(null, null);
                    case BoardAlight.BOARD -> pattern.getBoardType(i);
                    case BoardAlight.ALIGHT -> pattern.getAlightType(i);
                };
                result.set(i, pickDrop.isRoutable() || pickDrop.is(PickDrop.CANCELLED));
            }
        }
        if (this.wheelchairEnabled && this.wheelchairPreferences.stop().onlyConsiderAccessible()) {
            result = (BitSet)result.clone();
            result.and(tripPattern.getWheelchairAccessible());
            return result;
        }
        return result;
    }
}

