/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransitData;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.BoardAlight;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TransitDataProviderFilter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripPatternForDates;
import org.opentripplanner.transit.model.network.RoutingTripPattern;
import org.opentripplanner.transit.model.network.grouppriority.TransitGroupPriorityService;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.utils.time.DurationUtils;
import org.opentripplanner.utils.time.ServiceDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RaptorRoutingRequestTransitDataCreator {
    private static final Logger LOG = LoggerFactory.getLogger(RaptorRoutingRequestTransitDataCreator.class);
    private final RaptorTransitData raptorTransitData;
    private final ZonedDateTime transitSearchTimeZero;
    private final LocalDate departureDate;

    RaptorRoutingRequestTransitDataCreator(RaptorTransitData raptorTransitData, ZonedDateTime transitSearchTimeZero) {
        this.raptorTransitData = raptorTransitData;
        this.departureDate = ServiceDateUtils.asServiceDay((ZonedDateTime)transitSearchTimeZero);
        this.transitSearchTimeZero = transitSearchTimeZero;
    }

    public List<int[]> createTripPatternsPerStop(List<TripPatternForDates> tripPatternsForDate) {
        int stopCount = this.raptorTransitData.getStopCount();
        TIntArrayList[] patternsForStop = new TIntArrayList[stopCount];
        for (int i = 0; i < stopCount; ++i) {
            patternsForStop[i] = new TIntArrayList();
        }
        for (TripPatternForDates tripPatternForDateList : tripPatternsForDate) {
            RoutingTripPattern tripPattern = tripPatternForDateList.getTripPattern();
            int patternIndex = tripPattern.patternIndex();
            int numberOfStopsInPattern = tripPattern.numberOfStopsInPattern();
            for (int i = 0; i < numberOfStopsInPattern; ++i) {
                patternsForStop[tripPattern.stopIndex(i)].add(patternIndex);
            }
        }
        ArrayList<int[]> result = new ArrayList<int[]>(stopCount);
        for (TIntArrayList patterns : patternsForStop) {
            result.add(patterns.toArray());
        }
        return result;
    }

    public List<TripPatternForDates> createPatternIndex(List<TripPatternForDates> tripPatterns) {
        TripPatternForDates[] result = new TripPatternForDates[RoutingTripPattern.indexCounter()];
        Iterator<TripPatternForDates> iterator = tripPatterns.iterator();
        while (iterator.hasNext()) {
            TripPatternForDates pattern;
            result[pattern.getTripPattern().patternIndex()] = pattern = iterator.next();
        }
        return Arrays.asList(result);
    }

    static List<TripPatternForDates> merge(ZonedDateTime transitSearchTimeZero, List<TripPatternForDate> patternForDateList, TransitDataProviderFilter filter, TransitGroupPriorityService transitGroupPriorityService) {
        HashMap<RoutingTripPattern, List> patternForDateByPattern = new HashMap<RoutingTripPattern, List>();
        for (TripPatternForDate patternForDate : patternForDateList) {
            patternForDateByPattern.computeIfAbsent(patternForDate.getTripPattern(), k -> new ArrayList()).add(patternForDate);
        }
        ArrayList<TripPatternForDates> combinedList = new ArrayList<TripPatternForDates>();
        TObjectIntHashMap offsetCache = new TObjectIntHashMap();
        for (Map.Entry patternEntry : patternForDateByPattern.entrySet()) {
            Object[] patternsSorted = ((List)patternEntry.getValue()).toArray(new TripPatternForDate[0]);
            Arrays.sort(patternsSorted);
            int[] offsets = new int[patternsSorted.length];
            for (int i = 0; i < patternsSorted.length; ++i) {
                LocalDate serviceDate = ((TripPatternForDate)patternsSorted[i]).getServiceDate();
                if (offsetCache.containsKey((Object)serviceDate)) {
                    offsets[i] = offsetCache.get((Object)serviceDate);
                    continue;
                }
                offsets[i] = ServiceDateUtils.secondsSinceStartOfTime((ZonedDateTime)transitSearchTimeZero, (LocalDate)serviceDate);
                offsetCache.put((Object)serviceDate, offsets[i]);
            }
            RoutingTripPattern tripPattern = (RoutingTripPattern)patternEntry.getKey();
            combinedList.add(new TripPatternForDates(tripPattern, (TripPatternForDate[])patternsSorted, offsets, filter.filterAvailableStops(tripPattern, tripPattern.getBoardingPossible(), BoardAlight.BOARD), filter.filterAvailableStops(tripPattern, tripPattern.getAlightingPossible(), BoardAlight.ALIGHT), transitGroupPriorityService.lookupTransitGroupPriorityId(tripPattern.getPattern())));
        }
        return combinedList;
    }

    List<TripPatternForDates> createTripPatterns(int additionalPastSearchDays, int additionalFutureSearchDays, TransitDataProviderFilter filter, TransitGroupPriorityService transitGroupPriorityService) {
        List<TripPatternForDate> tripPatternForDates = this.getTripPatternsForDateRange(additionalPastSearchDays, additionalFutureSearchDays, filter);
        return RaptorRoutingRequestTransitDataCreator.merge(this.transitSearchTimeZero, tripPatternForDates, filter, transitGroupPriorityService);
    }

    private static List<TripPatternForDate> filterActiveTripPatterns(RaptorTransitData raptorTransitData, LocalDate date, boolean firstDay, TransitDataProviderFilter filter) {
        Predicate<TripTimes> tripTimesWithSubmodesPredicate = tripTimes -> filter.tripTimesPredicate((TripTimes)tripTimes, filter.hasSubModeFilters());
        Predicate<TripTimes> tripTimesWithoutSubmodesPredicate = tripTimes -> filter.tripTimesPredicate((TripTimes)tripTimes, false);
        Collection<TripPatternForDate> tripPatternsForDate = raptorTransitData.getTripPatternsForRunningDate(date);
        ArrayList<TripPatternForDate> result = new ArrayList<TripPatternForDate>(tripPatternsForDate.size());
        for (TripPatternForDate p : tripPatternsForDate) {
            Predicate<TripTimes> tripTimesPredicate;
            TripPatternForDate tripPatternForDate;
            if (!firstDay && !p.getStartOfRunningPeriod().equals(date) || !filter.tripPatternPredicate(p) || (tripPatternForDate = p.newWithFilteredTripTimes(tripTimesPredicate = p.getTripPattern().getPattern().getContainsMultipleModes() ? tripTimesWithSubmodesPredicate : tripTimesWithoutSubmodesPredicate)) == null) continue;
            result.add(tripPatternForDate);
        }
        return result;
    }

    private List<TripPatternForDate> getTripPatternsForDateRange(int additionalPastSearchDays, int additionalFutureSearchDays, TransitDataProviderFilter filter) {
        ArrayList<TripPatternForDate> tripPatternForDates = new ArrayList<TripPatternForDate>();
        long start = System.currentTimeMillis();
        for (int d = -additionalPastSearchDays; d <= additionalFutureSearchDays; ++d) {
            tripPatternForDates.addAll(RaptorRoutingRequestTransitDataCreator.filterActiveTripPatterns(this.raptorTransitData, this.departureDate.plusDays(d), d == 0, filter));
        }
        if (LOG.isDebugEnabled()) {
            String time = DurationUtils.msToSecondsStr((long)(System.currentTimeMillis() - start));
            long count = tripPatternForDates.size();
            LOG.debug("Prepare Transit model performed in {}, count: {}.", (Object)time, (Object)count);
        }
        return tripPatternForDates;
    }
}

