/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.raptor.api.model.RaptorConstrainedTransfer;
import org.opentripplanner.raptor.api.model.RaptorStopNameResolver;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.spi.IntIterator;
import org.opentripplanner.raptor.spi.RaptorConstrainedBoardingSearch;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.raptor.spi.RaptorPathConstrainedTransferSearch;
import org.opentripplanner.raptor.spi.RaptorRoute;
import org.opentripplanner.raptor.spi.RaptorSlackProvider;
import org.opentripplanner.raptor.spi.RaptorTransitDataProvider;
import org.opentripplanner.raptor.util.BitSetIterator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransferIndex;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransitData;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.SlackProvider;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedBoardingSearch;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedTransfersForPatterns;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferForPatternByStopPos;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.CostCalculatorFactory;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.GeneralizedCostParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.GeneralizedCostParametersMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRoutingRequestTransitDataCreator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TransitDataProviderFilter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripPatternForDates;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.transit.model.network.RoutingTripPattern;
import org.opentripplanner.transit.model.network.grouppriority.TransitGroupPriorityService;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.utils.time.ServiceDateUtils;

public class RaptorRoutingRequestTransitData
implements RaptorTransitDataProvider<TripSchedule> {
    private final RaptorTransitData raptorTransitData;
    private final TransferService transferService;
    private final List<int[]> activeTripPatternsPerStop;
    private final List<TripPatternForDates> patternIndex;
    private final RaptorTransferIndex transferIndex;
    private final ConstrainedTransfersForPatterns constrainedTransfers;
    private final ZonedDateTime transitSearchTimeZero;
    private final RaptorCostCalculator<TripSchedule> generalizedCostCalculator;
    private final RaptorSlackProvider slackProvider;
    private final int validTransitDataStartTime;
    private final int validTransitDataEndTime;

    public RaptorRoutingRequestTransitData(RaptorTransitData raptorTransitData, TransitGroupPriorityService transitGroupPriorityService, ZonedDateTime transitSearchTimeZero, int additionalPastSearchDays, int additionalFutureSearchDays, TransitDataProviderFilter filter, RouteRequest request) {
        this.transferService = raptorTransitData.getTransferService();
        this.raptorTransitData = raptorTransitData;
        this.transitSearchTimeZero = transitSearchTimeZero;
        RaptorRoutingRequestTransitDataCreator transitDataCreator = new RaptorRoutingRequestTransitDataCreator(raptorTransitData, transitSearchTimeZero);
        List<TripPatternForDates> tripPatterns = transitDataCreator.createTripPatterns(additionalPastSearchDays, additionalFutureSearchDays, filter, transitGroupPriorityService);
        this.patternIndex = transitDataCreator.createPatternIndex(tripPatterns);
        this.activeTripPatternsPerStop = transitDataCreator.createTripPatternsPerStop(tripPatterns);
        this.transferIndex = raptorTransitData.getRaptorTransfersForRequest(request);
        this.constrainedTransfers = raptorTransitData.getConstrainedTransfers();
        GeneralizedCostParameters mcCostParams = GeneralizedCostParametersMapper.map(request, this.patternIndex);
        this.generalizedCostCalculator = CostCalculatorFactory.createCostCalculator(mcCostParams, raptorTransitData.getStopBoardAlightTransferCosts());
        this.slackProvider = new SlackProvider((int)request.preferences().transfer().slack().toSeconds(), request.preferences().transit().boardSlack(), request.preferences().transit().alightSlack());
        this.validTransitDataStartTime = ServiceDateUtils.secondsSinceStartOfTime((ZonedDateTime)this.transitSearchTimeZero, (Instant)this.transitSearchTimeZero.minusDays(additionalPastSearchDays).toInstant());
        this.validTransitDataEndTime = ServiceDateUtils.secondsSinceStartOfTime((ZonedDateTime)this.transitSearchTimeZero, (Instant)this.transitSearchTimeZero.plusDays(additionalFutureSearchDays + 1).toInstant());
    }

    public RaptorRoutingRequestTransitData(RaptorRoutingRequestTransitData original, RaptorCostCalculator<TripSchedule> newCostCalculator) {
        this.raptorTransitData = original.raptorTransitData;
        this.transitSearchTimeZero = original.transitSearchTimeZero;
        this.activeTripPatternsPerStop = original.activeTripPatternsPerStop;
        this.patternIndex = original.patternIndex;
        this.transferIndex = original.transferIndex;
        this.transferService = original.transferService;
        this.constrainedTransfers = original.constrainedTransfers;
        this.validTransitDataStartTime = original.validTransitDataStartTime;
        this.validTransitDataEndTime = original.validTransitDataEndTime;
        this.generalizedCostCalculator = newCostCalculator;
        this.slackProvider = original.slackProvider();
    }

    public Iterator<RaptorTransfer> getTransfersFromStop(int stopIndex) {
        return this.transferIndex.getForwardTransfers(stopIndex).iterator();
    }

    public Iterator<? extends RaptorTransfer> getTransfersToStop(int stopIndex) {
        return this.transferIndex.getReversedTransfers(stopIndex).iterator();
    }

    public IntIterator routeIndexIterator(IntIterator stops) {
        BitSet activeTripPatternsForGivenStops = new BitSet(RoutingTripPattern.indexCounter());
        while (stops.hasNext()) {
            int[] patterns;
            for (int i : patterns = this.activeTripPatternsPerStop.get(stops.next())) {
                activeTripPatternsForGivenStops.set(i);
            }
        }
        return new BitSetIterator(activeTripPatternsForGivenStops);
    }

    public RaptorRoute<TripSchedule> getRouteForIndex(int routeIndex) {
        return this.patternIndex.get(routeIndex);
    }

    public int numberOfStops() {
        return this.raptorTransitData.getStopCount();
    }

    public RaptorCostCalculator<TripSchedule> multiCriteriaCostCalculator() {
        return this.generalizedCostCalculator;
    }

    public RaptorSlackProvider slackProvider() {
        return this.slackProvider;
    }

    public RaptorPathConstrainedTransferSearch<TripSchedule> transferConstraintsSearch() {
        if (OTPFeature.TransferConstraints.isOff() || this.transferService == null) {
            return null;
        }
        return new RaptorPathConstrainedTransferSearch<TripSchedule>(){

            @Nullable
            public RaptorConstrainedTransfer findConstrainedTransfer(TripSchedule fromTrip, int fromStopPosition, TripSchedule toTrip, int toStopPosition) {
                return RaptorRoutingRequestTransitData.this.transferService.findTransfer(fromTrip.getOriginalTripTimes().getTrip(), fromStopPosition, RaptorRoutingRequestTransitData.this.raptorTransitData.getStopByIndex(fromTrip.pattern().stopIndex(fromStopPosition)), toTrip.getOriginalTripTimes().getTrip(), toStopPosition, RaptorRoutingRequestTransitData.this.raptorTransitData.getStopByIndex(toTrip.pattern().stopIndex(toStopPosition)));
            }
        };
    }

    public RaptorStopNameResolver stopNameResolver() {
        return stopIndex -> {
            StopLocation s = this.raptorTransitData.getStopByIndex(stopIndex);
            return s == null ? "null" : String.valueOf(s.getName()) + "(" + stopIndex + ")";
        };
    }

    public int getValidTransitDataStartTime() {
        return this.validTransitDataStartTime;
    }

    public int getValidTransitDataEndTime() {
        return this.validTransitDataEndTime;
    }

    public RaptorConstrainedBoardingSearch<TripSchedule> transferConstraintsForwardSearch(int routeIndex) {
        TransferForPatternByStopPos fromStopTransfers = this.constrainedTransfers.fromStop(routeIndex);
        TransferForPatternByStopPos toStopTransfers = this.constrainedTransfers.toStop(routeIndex);
        if (fromStopTransfers == null && toStopTransfers == null) {
            return ConstrainedBoardingSearch.NOOP_SEARCH;
        }
        return new ConstrainedBoardingSearch(true, fromStopTransfers, toStopTransfers);
    }

    public RaptorConstrainedBoardingSearch<TripSchedule> transferConstraintsReverseSearch(int routeIndex) {
        TransferForPatternByStopPos fromStopTransfers = this.constrainedTransfers.toStop(routeIndex);
        TransferForPatternByStopPos toStopTransfers = this.constrainedTransfers.fromStop(routeIndex);
        if (fromStopTransfers == null && toStopTransfers == null) {
            return ConstrainedBoardingSearch.NOOP_SEARCH;
        }
        return new ConstrainedBoardingSearch(false, toStopTransfers, fromStopTransfers);
    }
}

