/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import gnu.trove.set.TIntSet;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.transit.model.timetable.FrequencyEntry;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripPatternForDateMapper {
    private static final Logger LOG = LoggerFactory.getLogger(TripPatternForDateMapper.class);
    private final Map<LocalDate, TIntSet> serviceCodesRunningForDate;

    TripPatternForDateMapper(Map<LocalDate, TIntSet> serviceCodesRunningForDate) {
        this.serviceCodesRunningForDate = serviceCodesRunningForDate;
    }

    @Nullable
    public TripPatternForDate map(Timetable timetable, LocalDate serviceDate) {
        TIntSet serviceCodesRunning = this.serviceCodesRunningForDate.get(serviceDate);
        if (serviceCodesRunning == null) {
            LOG.debug("Tried to update TripPattern {}, but no service codes are running for date {}", (Object)timetable.getPattern().getId(), (Object)serviceDate);
            return null;
        }
        ArrayList<TripTimes> times = new ArrayList<TripTimes>();
        for (TripTimes tripTimes : timetable.getTripTimes()) {
            if (!serviceCodesRunning.contains(tripTimes.getServiceCode()) || tripTimes.isDeleted()) continue;
            times.add(tripTimes);
        }
        List<FrequencyEntry> frequencies = timetable.getFrequencyEntries().stream().filter(frequency -> serviceCodesRunning.contains(frequency.tripTimes.getServiceCode())).sorted(Comparator.comparing(frequencyEntry -> frequencyEntry.startTime)).collect(Collectors.toList());
        if (times.isEmpty() && frequencies.isEmpty()) {
            if (timetable.getServiceDate() != null && timetable.getServiceDate().equals(serviceDate)) {
                LOG.debug("Tried to update TripPattern {}, but no service codes are valid for date {}", (Object)timetable.getPattern().getId(), (Object)serviceDate);
            }
            return null;
        }
        return new TripPatternForDate(timetable.getPattern().getRoutingTripPattern(), times, frequencies, serviceDate);
    }

    @Nullable
    public TripPatternForDate mapAndValidate(Timetable timetable, LocalDate serviceDate) throws IllegalArgumentException {
        TripPatternForDate result = this.map(timetable, serviceDate);
        if (result != null) {
            result.assertValidRunningPeriod();
        }
        return result;
    }
}

