/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.SiteRepository;
import org.opentripplanner.transit.service.TransitService;

class TransfersMapper {
    TransfersMapper() {
    }

    static List<List<Transfer>> mapTransfers(SiteRepository siteRepository, TransitService transitService) {
        ArrayList transfersByStopIndex = new ArrayList();
        for (int i = 0; i < siteRepository.stopIndexSize(); ++i) {
            StopLocation stop = siteRepository.stopByIndex(i);
            if (stop == null) continue;
            ArrayList<Transfer> list = new ArrayList<Transfer>();
            for (PathTransfer pathTransfer : transitService.findPathTransfers(stop)) {
                if (!(pathTransfer.to instanceof RegularStop)) continue;
                int toStopIndex = pathTransfer.to.getIndex();
                Transfer newTransfer = pathTransfer.getEdges() != null ? new Transfer(toStopIndex, pathTransfer.getEdges(), pathTransfer.getModes()) : new Transfer(toStopIndex, (int)Math.ceil(pathTransfer.getDistanceMeters()), pathTransfer.getModes());
                list.add(newTransfer);
            }
            transfersByStopIndex.add(List.copyOf(list));
        }
        return List.copyOf(transfersByStopIndex);
    }
}

