/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import com.google.common.collect.HashMultimap;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransitData;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferIndexGenerator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TripPatternForDateMapper;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.TripIdAndServiceDate;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TimetableRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealTimeRaptorTransitDataUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(RealTimeRaptorTransitDataUpdater.class);
    private final TimetableRepository timetableRepository;
    private final Map<LocalDate, Map<TripPattern, TripPatternForDate>> tripPatternsStartingOnDateMapCache = new HashMap<LocalDate, Map<TripPattern, TripPatternForDate>>();
    private final Map<TripIdAndServiceDate, TripPatternForDate> tripPatternsForTripIdAndServiceDateCache = new HashMap<TripIdAndServiceDate, TripPatternForDate>();
    private final Map<LocalDate, Set<TripPatternForDate>> tripPatternsRunningOnDateMapCache = new HashMap<LocalDate, Set<TripPatternForDate>>();

    public RealTimeRaptorTransitDataUpdater(TimetableRepository timetableRepository) {
        this.timetableRepository = timetableRepository;
    }

    public void update(Collection<Timetable> updatedTimetables, Map<TripPattern, SortedSet<Timetable>> timetables) {
        if (!this.timetableRepository.hasRealtimeRaptorTransitData()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        RaptorTransitData realtimeRaptorTransitData = new RaptorTransitData(this.timetableRepository.getRealtimeRaptorTransitData());
        TripPatternForDateMapper tripPatternForDateMapper = new TripPatternForDateMapper(this.timetableRepository.getServiceCodesRunningForDate());
        HashSet<LocalDate> datesToBeUpdated = new HashSet<LocalDate>();
        HashMultimap newTripPatternsForDate = HashMultimap.create();
        HashMultimap oldTripPatternsForDate = HashMultimap.create();
        TransferIndexGenerator transferIndexGenerator = null;
        if (OTPFeature.TransferConstraints.isOn()) {
            transferIndexGenerator = realtimeRaptorTransitData.getTransferIndexGenerator();
        }
        HashSet<TripPatternForDate> previouslyUsedPatterns = new HashSet<TripPatternForDate>();
        for (Timetable timetable : updatedTimetables) {
            Object newTripPatternForDate;
            TripPatternForDate oldTripPatternForDate;
            LocalDate date = timetable.getServiceDate();
            TripPattern tripPattern = timetable.getPattern();
            if (!this.tripPatternsStartingOnDateMapCache.containsKey(date)) {
                Map<TripPattern, TripPatternForDate> map = realtimeRaptorTransitData.getTripPatternsOnServiceDateCopy(date).stream().collect(Collectors.toMap(t -> t.getTripPattern().getPattern(), t -> t));
                this.tripPatternsStartingOnDateMapCache.put(date, map);
            }
            if ((oldTripPatternForDate = this.tripPatternsStartingOnDateMapCache.get(date).get(tripPattern)) != null) {
                this.tripPatternsStartingOnDateMapCache.get(date).remove(tripPattern, oldTripPatternForDate);
                oldTripPatternsForDate.put((Object)tripPattern, (Object)oldTripPatternForDate);
                datesToBeUpdated.addAll(oldTripPatternForDate.getRunningPeriodDates());
            }
            try {
                newTripPatternForDate = tripPatternForDateMapper.mapAndValidate(timetable, timetable.getServiceDate());
            }
            catch (IllegalArgumentException exception) {
                newTripPatternForDate = oldTripPatternForDate;
            }
            if (newTripPatternForDate == null) continue;
            this.tripPatternsStartingOnDateMapCache.get(date).put(tripPattern, (TripPatternForDate)newTripPatternForDate);
            newTripPatternsForDate.put((Object)tripPattern, newTripPatternForDate);
            datesToBeUpdated.addAll(((TripPatternForDate)newTripPatternForDate).getRunningPeriodDates());
            if (transferIndexGenerator != null && tripPattern.isCreatedByRealtimeUpdater()) {
                transferIndexGenerator.addRealtimeTrip(tripPattern, timetable.getTripTimes().stream().map(TripTimes::getTrip).collect(Collectors.toList()));
            }
            for (TripTimes triptimes : timetable.getTripTimes()) {
                TripIdAndServiceDate id = new TripIdAndServiceDate(triptimes.getTrip().getId(), timetable.getServiceDate());
                TripPatternForDate previousTripPatternForDate = this.tripPatternsForTripIdAndServiceDateCache.put(id, (TripPatternForDate)newTripPatternForDate);
                if (previousTripPatternForDate != null) {
                    previouslyUsedPatterns.add(previousTripPatternForDate);
                    continue;
                }
                LOG.debug("NEW TripPatternForDate: {} - {}", (Object)((TripPatternForDate)newTripPatternForDate).getServiceDate(), (Object)((TripPatternForDate)newTripPatternForDate).getTripPattern().debugInfo());
            }
        }
        for (LocalDate date : datesToBeUpdated) {
            this.tripPatternsRunningOnDateMapCache.computeIfAbsent(date, p -> new HashSet<TripPatternForDate>(realtimeRaptorTransitData.getTripPatternsRunningOnDateCopy(date)));
            Set<TripPatternForDate> patternsForDate = this.tripPatternsRunningOnDateMapCache.get(date);
            for (Map.Entry entry : oldTripPatternsForDate.asMap().entrySet()) {
                for (TripPatternForDate oldTripPatternForDate : (Collection)entry.getValue()) {
                    if (oldTripPatternForDate == null || !oldTripPatternForDate.getRunningPeriodDates().contains(date)) continue;
                    patternsForDate.remove(oldTripPatternForDate);
                }
            }
            for (TripPatternForDate tripPatternForDate : previouslyUsedPatterns) {
                TripPattern pattern;
                if (!tripPatternForDate.getServiceDate().equals(date) || !(pattern = tripPatternForDate.getTripPattern().getPattern()).isCreatedByRealtimeUpdater()) continue;
                SortedSet<Timetable> oldTimeTable = timetables.get(pattern);
                if (oldTimeTable != null) {
                    Boolean toRemove = oldTimeTable.stream().filter(tt -> tt.getServiceDate().equals(date)).findFirst().map(tt -> tt.getTripTimes().isEmpty()).orElse(false);
                    if (!toRemove.booleanValue()) continue;
                    patternsForDate.remove(tripPatternForDate);
                    continue;
                }
                LOG.warn("Could not fetch timetable for {}", (Object)pattern);
            }
            for (Map.Entry entry : newTripPatternsForDate.asMap().entrySet()) {
                for (TripPatternForDate newTripPatternForDate : (Collection)entry.getValue()) {
                    if (newTripPatternForDate == null || !newTripPatternForDate.getRunningPeriodDates().contains(date)) continue;
                    patternsForDate.add(newTripPatternForDate);
                }
            }
            realtimeRaptorTransitData.replaceTripPatternsForDate(date, new ArrayList<TripPatternForDate>(patternsForDate));
        }
        if (transferIndexGenerator != null) {
            realtimeRaptorTransitData.setConstrainedTransfers(transferIndexGenerator.generateTransfers());
        }
        this.timetableRepository.setRealtimeRaptorTransitData(realtimeRaptorTransitData);
        LOG.debug("UPDATING {} tripPatterns took {} ms", (Object)updatedTimetables.size(), (Object)(System.currentTimeMillis() - startTime));
    }
}

