/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import com.google.common.collect.ArrayListMultimap;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.raptor.api.model.RaptorCostConverter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransitData;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitTuningParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedTransfersForPatterns;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferIndexGenerator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransfersMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TripPatternForDateMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRequestTransferCache;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopTransferPriority;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.SiteRepository;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.transit.service.TransitService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaptorTransitDataMapper {
    private static final Logger LOG = LoggerFactory.getLogger(RaptorTransitDataMapper.class);
    private final TransitService transitService;
    private final SiteRepository siteRepository;

    private RaptorTransitDataMapper(TimetableRepository timetableRepository) {
        this.transitService = new DefaultTransitService(timetableRepository);
        this.siteRepository = timetableRepository.getSiteRepository();
    }

    public static RaptorTransitData map(TransitTuningParameters tuningParameters, TimetableRepository timetableRepository) {
        return new RaptorTransitDataMapper(timetableRepository).map(tuningParameters);
    }

    private RaptorTransitData map(TransitTuningParameters tuningParameters) {
        ConstrainedTransfersForPatterns constrainedTransfers = null;
        LOG.info("Mapping raptorTransitData from TimetableRepository...");
        Collection<TripPattern> allTripPatterns = this.transitService.listTripPatterns();
        HashMap<LocalDate, List<TripPatternForDate>> tripPatternsByStopByDate = this.mapTripPatterns(allTripPatterns);
        List<List<Transfer>> transfersByStopIndex = TransfersMapper.mapTransfers(this.siteRepository, this.transitService);
        TransferIndexGenerator transferIndexGenerator = null;
        if (OTPFeature.TransferConstraints.isOn()) {
            transferIndexGenerator = new TransferIndexGenerator(this.transitService.getTransferService().listAll(), allTripPatterns);
            constrainedTransfers = transferIndexGenerator.generateTransfers();
        }
        RaptorRequestTransferCache transferCache = new RaptorRequestTransferCache(tuningParameters.transferCacheMaxSize());
        LOG.info("Mapping complete.");
        return new RaptorTransitData(tripPatternsByStopByDate, transfersByStopIndex, this.transitService.getTransferService(), this.siteRepository, transferCache, constrainedTransfers, transferIndexGenerator, RaptorTransitDataMapper.createStopBoardAlightTransferCosts(this.siteRepository, tuningParameters));
    }

    private HashMap<LocalDate, List<TripPatternForDate>> mapTripPatterns(Collection<TripPattern> allTripPatterns) {
        TripPatternForDateMapper tripPatternForDateMapper = new TripPatternForDateMapper(this.transitService.getServiceCodesRunningForDate());
        Set<LocalDate> allServiceDates = this.transitService.listServiceDates();
        List<TripPatternForDate> tripPatternForDates = Collections.synchronizedList(new ArrayList());
        allServiceDates.parallelStream().forEach(serviceDate -> {
            ArrayList<TripPatternForDate> values = new ArrayList<TripPatternForDate>();
            for (TripPattern oldTripPattern : allTripPatterns) {
                TripPatternForDate tripPatternForDate = tripPatternForDateMapper.map(oldTripPattern.getScheduledTimetable(), (LocalDate)serviceDate);
                if (tripPatternForDate == null) continue;
                values.add(tripPatternForDate);
            }
            if (!values.isEmpty()) {
                tripPatternForDates.addAll(values);
            }
        });
        return this.keyByRunningPeriodDates(tripPatternForDates);
    }

    private HashMap<LocalDate, List<TripPatternForDate>> keyByRunningPeriodDates(List<TripPatternForDate> tripPatternForDates) {
        ArrayListMultimap multiMap = ArrayListMultimap.create();
        for (TripPatternForDate tripPatternForDate : tripPatternForDates) {
            for (LocalDate date : tripPatternForDate.getRunningPeriodDates()) {
                multiMap.put((Object)date, (Object)tripPatternForDate);
            }
        }
        HashMap<LocalDate, List<TripPatternForDate>> result = new HashMap<LocalDate, List<TripPatternForDate>>();
        for (Map.Entry entry : multiMap.asMap().entrySet()) {
            result.put((LocalDate)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        return result;
    }

    @Nullable
    static int[] createStopBoardAlightTransferCosts(SiteRepository stops, TransitTuningParameters tuningParams) {
        if (!tuningParams.enableStopTransferPriority()) {
            return null;
        }
        int defaultCost = RaptorCostConverter.toRaptorCost((int)tuningParams.stopBoardAlightDuringTransferCost(StopTransferPriority.defaultValue()));
        int[] stopBoardAlightTransferCosts = new int[stops.stopIndexSize()];
        for (int i = 0; i < stops.stopIndexSize(); ++i) {
            StopLocation stop = stops.stopByIndex(i);
            if (stop == null) {
                stopBoardAlightTransferCosts[i] = defaultCost;
                continue;
            }
            StopTransferPriority priority = stop.getPriority();
            int domainCost = tuningParams.stopBoardAlightDuringTransferCost(priority);
            stopBoardAlightTransferCosts[i] = RaptorCostConverter.toRaptorCost((int)domainCost);
        }
        return stopBoardAlightTransferCosts;
    }
}

