/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.model.plan.paging.cursor.PageCursor;
import org.opentripplanner.raptor.api.debug.DebugLogger;
import org.opentripplanner.raptor.api.debug.RaptorTimers;
import org.opentripplanner.raptor.api.model.GeneralizedCostRelaxFunction;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorCostConverter;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.RelaxFunction;
import org.opentripplanner.raptor.api.request.DebugRequestBuilder;
import org.opentripplanner.raptor.api.request.MultiCriteriaRequest;
import org.opentripplanner.raptor.api.request.Optimization;
import org.opentripplanner.raptor.api.request.RaptorRequest;
import org.opentripplanner.raptor.api.request.RaptorRequestBuilder;
import org.opentripplanner.raptor.api.request.RaptorTransitGroupPriorityCalculator;
import org.opentripplanner.raptor.api.request.RaptorViaLocation;
import org.opentripplanner.raptor.api.request.SearchParamsBuilder;
import org.opentripplanner.raptor.rangeraptor.SystemErrDebugLogger;
import org.opentripplanner.routing.algorithm.raptoradapter.router.performance.PerformanceTimersForRaptor;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.LookupStopIndexCallback;
import org.opentripplanner.routing.api.request.DebugEventType;
import org.opentripplanner.routing.api.request.DebugRaptor;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.framework.CostLinearFunction;
import org.opentripplanner.routing.api.request.preference.RaptorPreferences;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.request.preference.TransitPreferences;
import org.opentripplanner.routing.api.request.via.ViaLocation;
import org.opentripplanner.routing.via.ViaCoordinateTransferFactory;
import org.opentripplanner.routing.via.model.ViaCoordinateTransfer;
import org.opentripplanner.transit.model.network.grouppriority.DefaultTransitGroupPriorityCalculator;

public class RaptorRequestMapper<T extends RaptorTripSchedule> {
    private final RouteRequest request;
    private final Collection<? extends RaptorAccessEgress> accessPaths;
    private final Collection<? extends RaptorAccessEgress> egressPaths;
    private final long transitSearchTimeZeroEpocSecond;
    private final boolean isMultiThreadedEnbled;
    private final MeterRegistry meterRegistry;
    private final ViaCoordinateTransferFactory viaTransferResolver;
    private final LookupStopIndexCallback lookUpStopIndex;

    private RaptorRequestMapper(RouteRequest request, boolean isMultiThreaded, Collection<? extends RaptorAccessEgress> accessPaths, Collection<? extends RaptorAccessEgress> egressPaths, long transitSearchTimeZeroEpocSecond, @Nullable MeterRegistry meterRegistry, ViaCoordinateTransferFactory viaTransferResolver, LookupStopIndexCallback lookUpStopIndex) {
        this.request = Objects.requireNonNull(request);
        this.isMultiThreadedEnbled = isMultiThreaded;
        this.accessPaths = Objects.requireNonNull(accessPaths);
        this.egressPaths = Objects.requireNonNull(egressPaths);
        this.transitSearchTimeZeroEpocSecond = transitSearchTimeZeroEpocSecond;
        this.meterRegistry = meterRegistry;
        this.viaTransferResolver = Objects.requireNonNull(viaTransferResolver);
        this.lookUpStopIndex = Objects.requireNonNull(lookUpStopIndex);
    }

    public static <T extends RaptorTripSchedule> RaptorRequest<T> mapRequest(RouteRequest request, ZonedDateTime transitSearchTimeZero, boolean isMultiThreaded, Collection<? extends RaptorAccessEgress> accessPaths, Collection<? extends RaptorAccessEgress> egressPaths, MeterRegistry meterRegistry, ViaCoordinateTransferFactory viaTransferResolver, LookupStopIndexCallback lookUpStopIndex) {
        return new RaptorRequestMapper<T>(request, isMultiThreaded, accessPaths, egressPaths, transitSearchTimeZero.toEpochSecond(), meterRegistry, viaTransferResolver, lookUpStopIndex).doMap();
    }

    private RaptorRequest<T> doMap() {
        RaptorRequestBuilder builder = new RaptorRequestBuilder();
        SearchParamsBuilder searchParams = builder.searchParams();
        RoutingPreferences preferences = this.request.preferences();
        if (this.hasViaLocationsAndPassThroughLocations()) {
            throw new IllegalArgumentException("A mix of via-locations and pass-through is not allowed in this version.");
        }
        if (this.request.pageCursor() == null) {
            int time = this.relativeTime(this.request.dateTime());
            int timeLimit = this.relativeTime(preferences.transit().raptor().timeLimit());
            if (this.request.arriveBy()) {
                searchParams.latestArrivalTime(time);
                searchParams.earliestDepartureTime(timeLimit);
            } else {
                searchParams.earliestDepartureTime(time);
                searchParams.latestArrivalTime(timeLimit);
            }
            searchParams.searchWindow(this.request.searchWindow());
        } else {
            PageCursor c = this.request.pageCursor();
            if (c.earliestDepartureTime() != null) {
                searchParams.earliestDepartureTime(this.relativeTime(c.earliestDepartureTime()));
            }
            if (c.latestArrivalTime() != null) {
                searchParams.latestArrivalTime(this.relativeTime(c.latestArrivalTime()));
            }
            searchParams.searchWindow(c.searchWindow());
        }
        builder.searchParams().addViaLocations(this.mapViaLocations());
        if (preferences.transfer().maxTransfers() != null) {
            searchParams.maxNumberOfTransfers(preferences.transfer().maxTransfers().intValue());
        }
        if (preferences.transfer().maxAdditionalTransfers() != null) {
            searchParams.numberOfAdditionalTransfers(preferences.transfer().maxAdditionalTransfers().intValue());
        }
        builder.withMultiCriteria(mcBuilder -> {
            TransitPreferences pt = preferences.transit();
            RaptorPreferences r = pt.raptor();
            if (pt.isRelaxTransitGroupPrioritySet() && !this.hasPassThroughOnly()) {
                RaptorRequestMapper.mapRelaxTransitGroupPriority(mcBuilder, pt);
            } else if (!this.request.isViaSearch()) {
                r.relaxGeneralizedCostAtDestination().ifPresent(arg_0 -> ((MultiCriteriaRequest.Builder)mcBuilder).withRelaxCostAtDestination(arg_0));
            }
        });
        for (Optimization optimization : preferences.transit().raptor().optimizations()) {
            if (optimization.is(Optimization.PARALLEL)) {
                if (!this.isMultiThreadedEnbled) continue;
                builder.enableOptimization(optimization);
                continue;
            }
            builder.enableOptimization(optimization);
        }
        builder.profile(preferences.transit().raptor().profile());
        builder.searchDirection(preferences.transit().raptor().searchDirection());
        builder.searchParams().timetable(this.request.timetableView()).constrainedTransfers(OTPFeature.TransferConstraints.isOn()).addAccessPaths(this.accessPaths).addEgressPaths(this.egressPaths);
        DebugRaptor raptorDebugging = this.request.journey().transit().raptorDebugging();
        if (raptorDebugging.isEnabled()) {
            DebugRequestBuilder debug = builder.debug();
            SystemErrDebugLogger debugLogger = new SystemErrDebugLogger(true, false);
            debug.addStops(raptorDebugging.stops()).setPath(raptorDebugging.path()).debugPathFromStopIndex(raptorDebugging.debugPathFromStopIndex()).logger((DebugLogger)debugLogger);
            for (DebugEventType type : raptorDebugging.eventTypes()) {
                RaptorRequestMapper.addLogListenerForEachEventTypeRequested(debug, type, debugLogger);
            }
        }
        if (!this.request.timetableView() && this.request.arriveBy()) {
            builder.searchParams().preferLateArrival(true);
        }
        if (this.meterRegistry != null) {
            builder.performanceTimers((RaptorTimers)new PerformanceTimersForRaptor(builder.generateAlias(), preferences.system().tags(), this.meterRegistry));
        }
        return builder.build();
    }

    private boolean hasPassThroughOnly() {
        return this.request.isViaSearch() && this.request.getViaLocations().stream().allMatch(ViaLocation::isPassThroughLocation);
    }

    private boolean hasViaLocationsOnly() {
        return this.request.isViaSearch() && this.request.getViaLocations().stream().noneMatch(ViaLocation::isPassThroughLocation);
    }

    private boolean hasViaLocationsAndPassThroughLocations() {
        List<ViaLocation> c = this.request.getViaLocations();
        return this.request.isViaSearch() && c.stream().anyMatch(ViaLocation::isPassThroughLocation) && c.stream().anyMatch(Predicate.not(ViaLocation::isPassThroughLocation));
    }

    private List<RaptorViaLocation> mapViaLocations() {
        return this.request.getViaLocations().stream().map(this::mapViaLocation).toList();
    }

    private RaptorViaLocation mapViaLocation(ViaLocation input) {
        if (input.isPassThroughLocation()) {
            RaptorViaLocation.PassThroughBuilder builder = RaptorViaLocation.passThrough((String)input.label());
            for (int stopIndex : this.lookUpStopIndex.lookupStopLocationIndexes(input.stopLocationIds())) {
                builder.addPassThroughStop(stopIndex);
            }
            return builder.build();
        }
        HashSet<Integer> viaStops = new HashSet<Integer>();
        RaptorViaLocation.ViaVisitBuilder builder = RaptorViaLocation.via((String)input.label(), (Duration)input.minimumWaitTime());
        for (int stopIndex : this.lookUpStopIndex.lookupStopLocationIndexes(input.stopLocationIds())) {
            builder.addViaStop(stopIndex);
            viaStops.add(stopIndex);
        }
        Object object = input.coordinates().iterator();
        while (object.hasNext()) {
            WgsCoordinate coordinate = (WgsCoordinate)object.next();
            List<ViaCoordinateTransfer> viaTransfers = this.viaTransferResolver.createViaTransfers(this.request, input.label(), coordinate);
            for (ViaCoordinateTransfer it : viaTransfers) {
                if (it.stop() == it.fromStopIndex() && viaStops.contains(it.stop())) continue;
                builder.addViaTransfer(it.fromStopIndex(), (RaptorTransfer)it);
            }
        }
        return builder.build();
    }

    static RelaxFunction mapRelaxCost(CostLinearFunction relax) {
        if (relax == null) {
            return null;
        }
        return GeneralizedCostRelaxFunction.of((double)relax.coefficient(), (int)RaptorCostConverter.toRaptorCost((int)((Cost)relax.constant()).toSeconds()));
    }

    private int relativeTime(Instant time) {
        if (time == null) {
            return -1999000000;
        }
        return (int)(time.getEpochSecond() - this.transitSearchTimeZeroEpocSecond);
    }

    private static void mapRelaxTransitGroupPriority(MultiCriteriaRequest.Builder<?> mcBuilder, TransitPreferences pt) {
        mcBuilder.withTransitPriorityCalculator((RaptorTransitGroupPriorityCalculator)new DefaultTransitGroupPriorityCalculator());
        mcBuilder.withRelaxC1(RaptorRequestMapper.mapRelaxCost(pt.relaxTransitGroupPriority()));
    }

    private static void addLogListenerForEachEventTypeRequested(DebugRequestBuilder target, DebugEventType type, SystemErrDebugLogger logger) {
        switch (type) {
            case STOP_ARRIVALS: {
                target.stopArrivalListener(arg_0 -> ((SystemErrDebugLogger)logger).stopArrivalLister(arg_0));
                break;
            }
            case PATTERN_RIDES: {
                target.patternRideDebugListener(arg_0 -> ((SystemErrDebugLogger)logger).patternRideLister(arg_0));
                break;
            }
            case DESTINATION_ARRIVALS: {
                target.pathFilteringListener(arg_0 -> ((SystemErrDebugLogger)logger).pathFilteringListener(arg_0));
            }
        }
    }
}

