/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.routing.algorithm.raptoradapter.api.DefaultTripPattern;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.GeneralizedCostParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.GeneralizedCostParametersBuilder;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class GeneralizedCostParametersMapper {
    public static GeneralizedCostParameters map(RouteRequest request, List<? extends DefaultTripPattern> patternIndex) {
        GeneralizedCostParametersBuilder builder = GeneralizedCostParameters.of();
        RoutingPreferences preferences = request.preferences();
        builder.transferCost(preferences.transfer().cost()).waitReluctanceFactor(preferences.transfer().waitReluctance());
        StreetMode mode = request.journey().transfer().mode();
        if (mode == StreetMode.BIKE) {
            builder.boardCost(preferences.bike().boardCost());
        } else if (mode == StreetMode.CAR) {
            builder.boardCost(preferences.car().boardCost());
        } else {
            builder.boardCost(preferences.walk().boardCost());
        }
        builder.transitReluctanceFactors(GeneralizedCostParametersMapper.mapTransitReluctance(preferences.transit().reluctanceForMode()));
        builder.wheelchairEnabled(request.journey().wheelchair());
        builder.wheelchairAccessibility(preferences.wheelchair().trip());
        Set<FeedScopedId> unpreferredRoutes = Set.copyOf(request.journey().transit().unpreferredRoutes());
        Set<FeedScopedId> unpreferredAgencies = Set.copyOf(request.journey().transit().unpreferredAgencies());
        if (!unpreferredRoutes.isEmpty() || !unpreferredAgencies.isEmpty()) {
            BitSet unpreferredPatterns = new BitSet();
            for (DefaultTripPattern defaultTripPattern : patternIndex) {
                if (defaultTripPattern == null || !unpreferredRoutes.contains(defaultTripPattern.route().getId()) && !unpreferredAgencies.contains(defaultTripPattern.route().getAgency().getId())) continue;
                unpreferredPatterns.set(defaultTripPattern.patternIndex());
            }
            builder.unpreferredPatterns(unpreferredPatterns);
            builder.unpreferredCost(preferences.transit().unpreferredCost());
        }
        return builder.build();
    }

    public static double[] mapTransitReluctance(Map<TransitMode, Double> map) {
        if (map.isEmpty()) {
            return null;
        }
        double[] transitReluctance = new double[TransitMode.values().length];
        Arrays.fill(transitReluctance, 1.0);
        for (TransitMode mode : map.keySet()) {
            transitReluctance[mode.ordinal()] = map.get(mode);
        }
        return transitReluctance;
    }
}

