/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.frequency;

import java.time.LocalDate;
import org.opentripplanner.raptor.api.model.RaptorTransferConstraint;
import org.opentripplanner.raptor.api.model.RaptorTripPattern;
import org.opentripplanner.raptor.spi.RaptorBoardOrAlightEvent;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.DefaultTripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripPatternForDates;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.TripTimes;

abstract class FrequencyBoardOrAlightEvent<T extends DefaultTripSchedule>
implements RaptorBoardOrAlightEvent<T>,
TripSchedule {
    protected final TripPatternForDates raptorTripPattern;
    protected final TripTimes tripTimes;
    protected final int stopPositionInPattern;
    protected final int earliestDepartureTime;
    protected final int departureTime;
    protected final int offset;
    protected final int headway;
    protected final LocalDate serviceDate;
    private final Accessibility wheelChairBoarding;

    public FrequencyBoardOrAlightEvent(TripPatternForDates raptorTripPattern, TripTimes tripTimes, int stopPositionInPattern, int earliestDepartureTime, int departureTime, int offset, int headway, LocalDate serviceDate) {
        this.raptorTripPattern = raptorTripPattern;
        this.tripTimes = tripTimes;
        this.stopPositionInPattern = stopPositionInPattern;
        this.earliestDepartureTime = earliestDepartureTime;
        this.departureTime = departureTime;
        this.offset = offset;
        this.headway = headway;
        this.serviceDate = serviceDate;
        this.wheelChairBoarding = tripTimes.getWheelchairAccessibility();
    }

    public int tripIndex() {
        return this.tripTimes.getDepartureTime(0) + this.offset;
    }

    public T trip() {
        return (T)this;
    }

    public int stopPositionInPattern() {
        return this.stopPositionInPattern;
    }

    public int time() {
        return this.departureTime + this.offset;
    }

    public int earliestBoardTime() {
        return this.earliestDepartureTime;
    }

    public RaptorTransferConstraint transferConstraint() {
        return RaptorTransferConstraint.REGULAR_TRANSFER;
    }

    public boolean empty() {
        return false;
    }

    public int tripSortIndex() {
        return this.tripTimes.getDepartureTime(0) + this.offset;
    }

    public abstract int arrival(int var1);

    public abstract int departure(int var1);

    public RaptorTripPattern pattern() {
        return this.raptorTripPattern;
    }

    @Override
    public int transitReluctanceFactorIndex() {
        return this.raptorTripPattern.transitReluctanceFactorIndex();
    }

    @Override
    public TripTimes getOriginalTripTimes() {
        return this.tripTimes;
    }

    @Override
    public TripPattern getOriginalTripPattern() {
        return this.raptorTripPattern.getTripPattern().getPattern();
    }

    @Override
    public LocalDate getServiceDate() {
        return this.serviceDate;
    }

    @Override
    public boolean isFrequencyBasedTrip() {
        return true;
    }

    @Override
    public int frequencyHeadwayInSeconds() {
        return this.headway;
    }

    @Override
    public Accessibility wheelchairBoarding() {
        return this.wheelChairBoarding;
    }
}

