/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.cost;

import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorCostConverter;
import org.opentripplanner.raptor.api.model.RaptorTransferConstraint;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.DefaultTripSchedule;
import org.opentripplanner.routing.api.request.preference.AccessibilityPreferences;
import org.opentripplanner.transit.model.basic.Accessibility;

public class WheelchairCostCalculator<T extends DefaultTripSchedule>
implements RaptorCostCalculator<T> {
    private final RaptorCostCalculator<T> delegate;
    private final int[] wheelchairBoardingCost;

    public WheelchairCostCalculator(RaptorCostCalculator<T> delegate, AccessibilityPreferences wheelchairAccessibility) {
        this.delegate = delegate;
        this.wheelchairBoardingCost = WheelchairCostCalculator.createWheelchairCost(wheelchairAccessibility);
    }

    public int boardingCost(boolean firstBoarding, int prevArrivalTime, int boardStop, int boardTime, T trip, RaptorTransferConstraint transferConstraints) {
        int defaultCost = this.delegate.boardingCost(firstBoarding, prevArrivalTime, boardStop, boardTime, trip, transferConstraints);
        int index = trip.wheelchairBoarding().ordinal();
        int wheelchairCost = this.wheelchairBoardingCost[index];
        return defaultCost + wheelchairCost;
    }

    public int onTripRelativeRidingCost(int boardTime, T tripScheduledBoarded) {
        return this.delegate.onTripRelativeRidingCost(boardTime, tripScheduledBoarded);
    }

    public int transitArrivalCost(int boardCost, int alightSlack, int transitTime, T trip, int toStop) {
        return this.delegate.transitArrivalCost(boardCost, alightSlack, transitTime, trip, toStop);
    }

    public int waitCost(int waitTimeInSeconds) {
        return this.delegate.waitCost(waitTimeInSeconds);
    }

    public int calculateRemainingMinCost(int minTravelTime, int minNumTransfers, int fromStop) {
        return this.delegate.calculateRemainingMinCost(minTravelTime, minNumTransfers, fromStop);
    }

    public int costEgress(RaptorAccessEgress egress) {
        return this.delegate.costEgress(egress);
    }

    private static int[] createWheelchairCost(AccessibilityPreferences requirements) {
        int[] costIndex = new int[Accessibility.values().length];
        for (Accessibility it : Accessibility.values()) {
            int n = it.ordinal();
            costIndex[n] = switch (it) {
                default -> throw new MatchException(null, null);
                case Accessibility.POSSIBLE -> 0;
                case Accessibility.NO_INFORMATION -> RaptorCostConverter.toRaptorCost((int)requirements.unknownCost());
                case Accessibility.NOT_POSSIBLE -> RaptorCostConverter.toRaptorCost((int)requirements.inaccessibleCost());
            };
        }
        return costIndex;
    }
}

