/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.cost;

import java.util.Objects;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.raptor.api.model.RaptorCostConverter;
import org.opentripplanner.routing.api.request.framework.CostLinearFunction;
import org.opentripplanner.routing.api.request.framework.LinearFunctionSerialization;

class RaptorCostLinearFunction {
    private final int constant;
    private final int coefficient;
    static final RaptorCostLinearFunction ZERO_FUNCTION = new RaptorCostLinearFunction(0, 0.0);

    private RaptorCostLinearFunction(int constantSeconds, double coefficient) {
        this.constant = RaptorCostConverter.toRaptorCost((int)constantSeconds);
        this.coefficient = RaptorCostConverter.toRaptorCost((double)coefficient);
    }

    static RaptorCostLinearFunction of(int constantSeconds, double coefficient) {
        if (constantSeconds == 0 && coefficient == 0.0) {
            return ZERO_FUNCTION;
        }
        return new RaptorCostLinearFunction(constantSeconds, coefficient);
    }

    static RaptorCostLinearFunction of(CostLinearFunction otpDomainFunction) {
        return RaptorCostLinearFunction.of(((Cost)otpDomainFunction.constant()).toSeconds(), otpDomainFunction.coefficient());
    }

    int calculateRaptorCost(int durationInSeconds) {
        return this.constant + this.coefficient * durationInSeconds;
    }

    boolean isZero() {
        return this.constant == 0 && this.coefficient == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RaptorCostLinearFunction that = (RaptorCostLinearFunction)o;
        return this.constant == that.constant && this.coefficient == that.coefficient;
    }

    public int hashCode() {
        return Objects.hash(this.constant, this.coefficient);
    }

    public String toString() {
        return this.isZero() ? "ZERO FUNCTION" : LinearFunctionSerialization.serialize(RaptorCostConverter.raptorCostToDuration((int)this.constant), RaptorCostConverter.toOtpDomainFactor((int)this.coefficient));
    }
}

