/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.cost;

import java.util.BitSet;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTransferConstraint;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.DefaultTripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostLinearFunction;

class PatternCostCalculator<T extends DefaultTripSchedule>
implements RaptorCostCalculator<T> {
    private final RaptorCostCalculator<T> delegate;
    private final BitSet unpreferredPatterns;
    private final RaptorCostLinearFunction unpreferredCost;

    PatternCostCalculator(RaptorCostCalculator<T> delegate, BitSet unpreferredPatterns, RaptorCostLinearFunction unpreferredCost) {
        this.unpreferredPatterns = unpreferredPatterns;
        this.delegate = delegate;
        this.unpreferredCost = unpreferredCost;
    }

    public int boardingCost(boolean firstBoarding, int prevArrivalTime, int boardStop, int boardTime, T trip, RaptorTransferConstraint transferConstraints) {
        return this.delegate.boardingCost(firstBoarding, prevArrivalTime, boardStop, boardTime, trip, transferConstraints);
    }

    public int onTripRelativeRidingCost(int boardTime, T tripScheduledBoarded) {
        return this.delegate.onTripRelativeRidingCost(boardTime, tripScheduledBoarded);
    }

    public int transitArrivalCost(int boardCost, int alightSlack, int transitTime, T trip, int toStop) {
        int defaultCost = this.delegate.transitArrivalCost(boardCost, alightSlack, transitTime, trip, toStop);
        boolean includeUnpreferredCost = this.unpreferredPatterns.get(trip.pattern().patternIndex());
        if (includeUnpreferredCost) {
            int unpreferredCostValue = this.unpreferredCost.calculateRaptorCost(transitTime);
            return defaultCost + unpreferredCostValue;
        }
        return defaultCost;
    }

    public int waitCost(int waitTimeInSeconds) {
        return this.delegate.waitCost(waitTimeInSeconds);
    }

    public int calculateRemainingMinCost(int minTravelTime, int minNumTransfers, int fromStop) {
        return this.delegate.calculateRemainingMinCost(minTravelTime, minNumTransfers, fromStop);
    }

    public int costEgress(RaptorAccessEgress egress) {
        return this.delegate.costEgress(egress);
    }
}

