/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.cost;

import java.util.Arrays;
import org.opentripplanner.raptor.api.model.RaptorCostConverter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.FactorStrategy;

final class IndexBasedFactorStrategy
implements FactorStrategy {
    private final int[] factors;
    private final int minFactor;

    private IndexBasedFactorStrategy(int[] factors) {
        this.factors = factors;
        this.minFactor = IndexBasedFactorStrategy.findMinimumFactor(factors);
    }

    IndexBasedFactorStrategy(double[] reluctanceByIndex) {
        this(RaptorCostConverter.toRaptorCosts((double[])reluctanceByIndex));
    }

    @Override
    public int factor(int index) {
        return this.factors[index];
    }

    @Override
    public int minFactor() {
        return this.minFactor;
    }

    private static int findMinimumFactor(int[] factors) {
        return Arrays.stream(factors).min().orElseThrow();
    }
}

