/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.cost;

import java.util.BitSet;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.GeneralizedCostParametersBuilder;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostLinearFunction;
import org.opentripplanner.routing.api.request.preference.AccessibilityPreferences;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class GeneralizedCostParameters {
    public static final double DEFAULT_TRANSIT_RELUCTANCE = 1.0;
    public static final RaptorCostLinearFunction UNPREFERRED_COST = RaptorCostLinearFunction.of(0, 1.0);
    public static final GeneralizedCostParameters DEFAULTS = new GeneralizedCostParameters();
    private final int boardCost;
    private final int transferCost;
    private final double[] transitReluctanceFactors;
    private final double waitReluctanceFactor;
    private final boolean wheelchairEnabled;
    private final AccessibilityPreferences wheelchairAccessibility;
    private final BitSet unpreferredPatterns;
    private final RaptorCostLinearFunction unpreferredCost;

    private GeneralizedCostParameters() {
        this.boardCost = 600;
        this.transferCost = 0;
        this.transitReluctanceFactors = null;
        this.waitReluctanceFactor = 1.0;
        this.wheelchairEnabled = false;
        this.wheelchairAccessibility = AccessibilityPreferences.ofOnlyAccessible();
        this.unpreferredPatterns = new BitSet();
        this.unpreferredCost = UNPREFERRED_COST;
    }

    GeneralizedCostParameters(GeneralizedCostParametersBuilder builder) {
        this.boardCost = builder.boardCost();
        this.transferCost = builder.transferCost();
        this.transitReluctanceFactors = builder.transitReluctanceFactors();
        this.waitReluctanceFactor = builder.waitReluctanceFactor();
        this.wheelchairEnabled = builder.wheelchairEnabled();
        this.wheelchairAccessibility = builder.wheelchairAccessibility();
        this.unpreferredPatterns = Objects.requireNonNull(builder.unpreferredPatterns());
        this.unpreferredCost = Objects.requireNonNull(builder.unpreferredCost());
    }

    public static GeneralizedCostParametersBuilder of() {
        return new GeneralizedCostParametersBuilder(DEFAULTS);
    }

    public int boardCost() {
        return this.boardCost;
    }

    public int transferCost() {
        return this.transferCost;
    }

    @Nullable
    public double[] transitReluctanceFactors() {
        return this.transitReluctanceFactors;
    }

    public double waitReluctanceFactor() {
        return this.waitReluctanceFactor;
    }

    public boolean wheelchairEnabled() {
        return this.wheelchairEnabled;
    }

    public AccessibilityPreferences wheelchairAccessibility() {
        return this.wheelchairAccessibility;
    }

    public BitSet unpreferredPatterns() {
        return this.unpreferredPatterns;
    }

    public RaptorCostLinearFunction unnpreferredCost() {
        return this.unpreferredCost;
    }

    public int hashCode() {
        return Objects.hash(this.boardCost, this.transferCost, this.waitReluctanceFactor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneralizedCostParameters that = (GeneralizedCostParameters)o;
        return this.boardCost == that.boardCost && this.transferCost == that.transferCost && Double.compare(that.waitReluctanceFactor, this.waitReluctanceFactor) == 0;
    }

    public String toString() {
        return ToStringBuilder.of(GeneralizedCostParameters.class).addNum("boardCost", (Number)this.boardCost, (Number)GeneralizedCostParameters.DEFAULTS.boardCost).addNum("transferCost", (Number)this.transferCost, (Number)GeneralizedCostParameters.DEFAULTS.transferCost).addNum("waitReluctanceFactor", (Number)this.waitReluctanceFactor, (Number)GeneralizedCostParameters.DEFAULTS.waitReluctanceFactor).addDoubles("transitReluctanceFactors", this.transitReluctanceFactors, 1.0).addNum("unpreferredPatternsSize", (Number)this.unpreferredPatterns.size(), (Number)0).addObj("unpreferredCost", (Object)this.unpreferredCost, (Object)UNPREFERRED_COST).toString();
    }
}

