/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.cost;

import javax.annotation.Nullable;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorCostConverter;
import org.opentripplanner.raptor.api.model.RaptorTransferConstraint;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.DefaultTripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.FactorStrategy;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.GeneralizedCostParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.IndexBasedFactorStrategy;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.SingleValueFactorStrategy;

public final class DefaultCostCalculator<T extends DefaultTripSchedule>
implements RaptorCostCalculator<T> {
    private final int boardCostOnly;
    private final int transferCostOnly;
    private final int boardAndTransferCost;
    private final int waitFactor;
    private final FactorStrategy transitFactors;
    @Nullable
    private final int[] stopBoardAlightTransferCosts;

    public DefaultCostCalculator(int boardCost, int transferCost, double waitReluctanceFactor, @Nullable double[] transitReluctanceFactors, @Nullable int[] stopBoardAlightTransferCosts) {
        this.boardCostOnly = RaptorCostConverter.toRaptorCost((int)boardCost);
        this.transferCostOnly = RaptorCostConverter.toRaptorCost((int)transferCost);
        this.boardAndTransferCost = this.transferCostOnly + this.boardCostOnly;
        this.waitFactor = RaptorCostConverter.toRaptorCost((double)waitReluctanceFactor);
        this.transitFactors = transitReluctanceFactors == null ? new SingleValueFactorStrategy(1.0) : new IndexBasedFactorStrategy(transitReluctanceFactors);
        this.stopBoardAlightTransferCosts = stopBoardAlightTransferCosts;
    }

    public DefaultCostCalculator(GeneralizedCostParameters params, @Nullable int[] stopBoardAlightTransferCosts) {
        this(params.boardCost(), params.transferCost(), params.waitReluctanceFactor(), params.transitReluctanceFactors(), stopBoardAlightTransferCosts);
    }

    public int boardingCost(boolean firstBoarding, int prevArrivalTime, int boardStop, int boardTime, T trip, RaptorTransferConstraint transferConstraints) {
        if (transferConstraints.isRegularTransfer()) {
            return this.boardingCostRegularTransfer(firstBoarding, prevArrivalTime, boardStop, boardTime);
        }
        return this.boardingCostConstrainedTransfer(prevArrivalTime, boardStop, boardTime, trip.transitReluctanceFactorIndex(), firstBoarding, transferConstraints);
    }

    public int onTripRelativeRidingCost(int boardTime, DefaultTripSchedule tripScheduledBoarded) {
        return -boardTime * this.transitFactors.factor(tripScheduledBoarded.transitReluctanceFactorIndex());
    }

    public int transitArrivalCost(int boardCost, int alightSlack, int transitTime, T trip, int toStop) {
        int cost = boardCost + this.transitFactors.factor(trip.transitReluctanceFactorIndex()) * transitTime + this.waitFactor * alightSlack;
        if (this.stopBoardAlightTransferCosts != null) {
            cost += this.stopBoardAlightTransferCosts[toStop];
        }
        return cost;
    }

    public int waitCost(int waitTimeInSeconds) {
        return this.waitFactor * waitTimeInSeconds;
    }

    public int calculateRemainingMinCost(int minTravelTime, int minNumTransfers, int fromStop) {
        if (minNumTransfers > -1) {
            return this.boardCostOnly + this.boardAndTransferCost * minNumTransfers + this.transitFactors.minFactor() * minTravelTime;
        }
        int fixedCost = this.transitFactors.minFactor() * minTravelTime;
        return this.stopBoardAlightTransferCosts == null ? fixedCost : fixedCost - this.stopBoardAlightTransferCosts[fromStop];
    }

    public int costEgress(RaptorAccessEgress egress) {
        if (egress.hasRides()) {
            return egress.c1() + this.transferCostOnly;
        }
        if (this.stopBoardAlightTransferCosts != null) {
            return egress.c1() - this.stopBoardAlightTransferCosts[egress.stop()];
        }
        return egress.c1();
    }

    public int boardingCostRegularTransfer(boolean firstBoarding, int prevArrivalTime, int boardStop, int boardTime) {
        int boardWaitTime = boardTime - prevArrivalTime;
        int cost = this.waitFactor * boardWaitTime;
        cost += firstBoarding ? this.boardCostOnly : this.boardAndTransferCost;
        if (this.stopBoardAlightTransferCosts != null && !firstBoarding) {
            cost += this.stopBoardAlightTransferCosts[boardStop];
        }
        return cost;
    }

    private int boardingCostConstrainedTransfer(int prevArrivalTime, int boardStop, int boardTime, int transitReluctanceIndex, boolean firstBoarding, RaptorTransferConstraint txConstraints) {
        TransferConstraint tx = (TransferConstraint)txConstraints;
        if (tx.isStaySeated()) {
            int boardWaitTime = boardTime - prevArrivalTime;
            int transitReluctance = this.transitFactors.factor(transitReluctanceIndex);
            return transitReluctance * boardWaitTime;
        }
        if (tx.isGuaranteed()) {
            int boardWaitTime = boardTime - prevArrivalTime;
            return this.waitFactor * boardWaitTime;
        }
        return this.boardingCostRegularTransfer(firstBoarding, prevArrivalTime, boardStop, boardTime);
    }
}

